/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.podloot.eyemod.EyeApps;
import com.podloot.eyemod.EyeClient;
import com.podloot.eyemod.config.EyeConfigData;
import com.podloot.eyemod.events.EyeAppEvent;
import com.podloot.eyemod.events.EyeDeviceEvent;
import com.podloot.eyemod.events.EyeEvents;
import com.podloot.eyemod.events.EyeMoneyEvent;
import com.podloot.eyemod.gui.apps.App;
import com.podloot.eyemod.gui.apps.AppHome;
import com.podloot.eyemod.gui.apps.AppStart;
import com.podloot.eyemod.gui.elements.Background;
import com.podloot.eyemod.gui.elements.Border;
import com.podloot.eyemod.gui.elements.DeviceButton;
import com.podloot.eyemod.gui.elements.StatusBar;
import com.podloot.eyemod.gui.panes.ConfirmPane;
import com.podloot.eyemod.gui.util.ConnectionManager;
import com.podloot.eyemod.gui.util.Naming;
import com.podloot.eyemod.gui.util.NbtManager;
import com.podloot.eyemod.gui.util.Photos;
import com.podloot.eyemod.gui.util.SettingManager;
import com.podloot.eyemod.gui.util.Time;
import com.podloot.eyemod.gui.util.Timer;
import com.podloot.eyemod.gui.util.commands.CommandManager;
import com.podloot.eyemod.items.ItemDevice;
import com.podloot.eyemod.lib.gui.EyeLib;
import com.podloot.eyemod.lib.gui.EyeScreen;
import com.podloot.eyemod.lib.gui.util.Line;
import com.podloot.eyemod.network.PacketHandler;
import com.podloot.eyemod.network.ServerItemRemove;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public abstract class GuiDevice
extends EyeScreen {
    public NbtManager data;
    public SettingManager settings;
    public ConnectionManager connect;
    public CommandManager command;
    public EyeConfigData config;
    int refresh = 0;
    App currentApp;
    int lastPage = 0;
    Border border;
    Background background;
    StatusBar bar;
    public Map<ResourceLocation, App> loaded_apps = new HashMap<ResourceLocation, App>();
    private boolean operator = false;
    private boolean opApps = false;
    private InteractionHand hand;
    private String[][] mails = new String[][]{{"Store", "Update", "Hello {u},|The {ia} app just had an update, go check it out!|Kind regards,|EyeStore"}, {"Store", "New", "Hello {u},|Did you already check out the {ua} app in the store?|Kind regards,|EyeStore"}, {"News", "Look out", "There seem to be some lose withers flying around, please close your windows to prevent further damage."}, {"News", "Outbreak", "Some villagers escaped their trading facility, if you find some suspicious villagers, please notify the authorities!"}, {"News", "Missing", "A wandering trader hasn't returned home yet... Do you know more about this?"}, {"News", "Nuisance", "There have been a lot of complaints about some flying creatures, however a solution is yet to be found..."}};

    public GuiDevice(String title, int width, int height, InteractionHand hand, CompoundTag config, boolean operator, boolean opApps) {
        super(title, width, height);
        this.hand = hand;
        this.operator = operator;
        this.opApps = opApps;
        this.config = new EyeConfigData(config);
        this.data = new NbtManager(hand);
        this.settings = new SettingManager(this.data);
        this.connect = new ConnectionManager(this);
        this.command = new CommandManager(this, operator);
        this.initDevice();
        this.initApps();
        this.sendSpam(20);
    }

    @Override
    public void m_7379_() {
        MinecraftForge.EVENT_BUS.post((Event)new EyeDeviceEvent(EyeEvents.EventSide.CLIENT, (Player)this.getUser(), this.getItem(), EyeEvents.DeviceAction.Close));
        super.m_7379_();
    }

    public void initDevice() {
        this.base.clear();
        int deviceColor = this.settings.getInt("device");
        this.border = new Border(this.base.getWidth(), this.base.getHeight(), deviceColor);
        this.base.add(this.border, 0, 0);
        this.background = new Background(this.getAppWidth(), this.getAppHeight() + 8, this.settings.get("background"));
        this.base.add(this.background, this.getAppX(), this.getAppY() - 8);
        this.bar = new StatusBar(this, this.getAppWidth(), 8);
        this.base.add(this.bar, this.getAppX(), this.getAppY() - 8);
        DeviceButton home = new DeviceButton(20, 20, EyeLib.DEVICE_HOME);
        home.setColor(deviceColor);
        home.setAction(() -> {
            if (this.currentApp != null) {
                this.currentApp.onHomeGeneral();
            }
        });
        this.base.add(home, this.base.getWidth() / 2 - 10, this.base.getHeight() - 22);
        DeviceButton left = new DeviceButton(11, 16, EyeLib.DEVICE_LEFT);
        left.setColor(deviceColor);
        left.setAction(() -> {
            if (this.currentApp != null) {
                this.currentApp.onLeft();
            }
        });
        this.base.add(left, this.base.getWidth() / 2 - 23, this.base.getHeight() - 20);
        DeviceButton right = new DeviceButton(11, 16, EyeLib.DEVICE_RIGHT);
        right.setColor(deviceColor);
        right.setAction(() -> {
            if (this.currentApp != null) {
                this.currentApp.onRight();
            }
        });
        this.base.add(right, this.base.getWidth() / 2 + 12, this.base.getHeight() - 20);
        DeviceButton quit = new DeviceButton(16, 8, EyeLib.DEVICE_QUIT);
        quit.setColor(deviceColor);
        quit.setAction(() -> this.closeDevice());
        this.base.add(quit, this.base.getWidth() - 32, 6);
        DeviceButton screenshot = new DeviceButton(8, 8, EyeLib.DEVICE_SCREENSHOT);
        screenshot.setColor(deviceColor);
        screenshot.setAction(() -> {
            String save = "Screenshot_" + Time.getTime().replace(":", "_");
            boolean saved = false;
            saved = this.settings.getBool("camera_res") ? Photos.takeShot(save) : Photos.takeShotLow(save);
            if (saved) {
                this.addNotification(EyeClient.APPPHOTOS.getId(), "New screenshot: " + save);
            } else {
                this.addNotification(EyeClient.APPPHOTOS.getId(), "Failed to save: " + save);
            }
        });
        if (this.isInstalled(EyeClient.APPCAMERA.getId())) {
            this.base.add(screenshot, this.base.getWidth() - 44, 6);
        }
    }

    public void hidePanel(boolean background, boolean bar) {
        this.background.hide(background);
        this.bar.hide(bar);
    }

    public void initApps() {
        this.loaded_apps.clear();
        for (App a : EyeApps.getApps()) {
            this.addApp(a);
        }
        AppStart h = new AppStart();
        h.set(this, 0, 0);
        this.openApp(h);
    }

    private void addApp(App app) {
        int access = this.config.getAccess(app.getId().toString());
        int price = this.config.getPrice(app.getId().toString());
        if (access == -1) {
            access = app.getAccess();
        }
        if (price == -1) {
            price = app.getPrice();
        }
        if (access == 2) {
            return;
        }
        if (access == 1 && !this.operator) {
            return;
        }
        if (!this.opApps && app.isOP()) {
            return;
        }
        app.set(this, price, access);
        this.loaded_apps.put(app.getId(), app);
    }

    public boolean openApp(App app) {
        if (app.getDevice() == null) {
            return false;
        }
        boolean connected = this.connect.isConnected();
        boolean loc = this.settings.getBool("location");
        if (app.useNet() && !connected) {
            if (this.currentApp != null) {
                ConfirmPane con = new ConfirmPane(this.currentApp, this.getAppWidth() - 8, 48, new Line("text.eyemod.notify_connection"), false);
                this.currentApp.openPane(con);
            }
            return false;
        }
        if (app.useLocation() && !loc) {
            if (this.currentApp != null) {
                ConfirmPane con = new ConfirmPane(this.currentApp, this.getAppWidth() - 8, 48, new Line("text.eyemod.notify_location"), false);
                this.currentApp.openPane(con);
            }
            return false;
        }
        if (app.isStock() || this.isInstalled(app.getId())) {
            if (this.currentApp != null) {
                this.currentApp.close();
                this.base.remove(this.currentApp);
            }
            MinecraftForge.EVENT_BUS.post((Event)new EyeAppEvent(EyeEvents.EventSide.CLIENT, (Player)this.getUser(), this.getItem(), app, EyeEvents.AppAction.Open));
            this.currentApp = app;
            app.setSize(this.getAppWidth(), this.getAppHeight());
            this.base.add(app, this.getAppX(), this.getAppY());
            app.open();
            this.clearNotifications(app.getId());
            return true;
        }
        return false;
    }

    public boolean openApp(ResourceLocation app) {
        return this.openApp(this.getApp(app));
    }

    public List<App> getInstalledApps() {
        ListTag apps = this.data.getList("apps", Naming.Type.STRING);
        ArrayList<App> allowed = new ArrayList<App>();
        for (int i = 0; i < apps.size(); ++i) {
            ResourceLocation id = new ResourceLocation(apps.m_128778_(i));
            if (!this.loaded_apps.containsKey(id)) continue;
            allowed.add(this.loaded_apps.get(id));
        }
        return allowed;
    }

    public App getApp(ResourceLocation id) {
        if (this.loaded_apps.containsKey(id)) {
            return this.loaded_apps.get(id);
        }
        return null;
    }

    public void openHome() {
        AppHome h = new AppHome(this.lastPage);
        h.set(this, 0, 0);
        this.openApp(h);
    }

    public void openConsole() {
        this.openApp(EyeClient.APPCONSOLE);
    }

    public void closeDevice() {
        Minecraft.m_91087_().m_91152_(null);
        Minecraft.m_91087_().f_91067_.m_91603_();
        this.m_7379_();
    }

    @Override
    public void paint(PoseStack matrices) {
        if (this.refresh > 0) {
            if (this.refresh == 1) {
                this.onRefresh();
            }
            --this.refresh;
        }
    }

    @Override
    public void update(int mouseX, int mouseY) {
        this.data.update();
    }

    public LocalPlayer getUser() {
        return Minecraft.m_91087_().f_91074_;
    }

    public String getOwner() {
        return this.data.getString("user");
    }

    public boolean isLocked() {
        boolean locked = !this.getUser().m_6302_().equals(this.getOwner());
        return this.data.getBool("faceid") ? locked : false;
    }

    public ItemStack getItem() {
        return this.getUser().m_21120_(this.hand);
    }

    public ResourceLocation getWorldID() {
        return this.getUser().m_9236_().m_46472_().m_135782_();
    }

    public int getAppWidth() {
        return this.base.getWidth() - 20;
    }

    public int getAppHeight() {
        return this.base.getHeight() - 48 - 8;
    }

    public int getAppX() {
        return 10;
    }

    public int getAppY() {
        return 32;
    }

    public ItemStack getCurrency() {
        String id = this.config.getString("currency");
        if (id.contains(":")) {
            Item i = (Item)Registry.f_122827_.m_7745_(new ResourceLocation(id.split(":")[0], id.split(":")[1]));
            if (i != null) {
                return i.m_7968_();
            }
            return Items.f_42616_.m_7968_();
        }
        return Items.f_42616_.m_7968_();
    }

    public void clearAll() {
        CompoundTag empty = new CompoundTag();
        empty.m_128365_("apps", (Tag)this.data.getList("apps", Naming.Type.STRING));
        empty.m_128405_("Damage", this.data.getInt("Damage"));
        empty.m_128405_("money", this.data.getInt("money"));
        this.data.updateNbt(empty);
    }

    public boolean hasData() {
        boolean b = this.data.hasStorage();
        if (b) {
            return true;
        }
        if (this.currentApp != null) {
            ConfirmPane out = new ConfirmPane(this.currentApp, this.getAppWidth() - 4, 36, new Line("text.eyemod.notify_storage"), false);
            this.currentApp.openPane(out);
        }
        return false;
    }

    public boolean hasRouterData() {
        boolean b;
        boolean bl = b = this.connect.getRouterData().storage < this.connect.getRouterData().max_storage;
        if (b) {
            return true;
        }
        if (this.currentApp != null) {
            ConfirmPane out = new ConfirmPane(this.currentApp, this.getAppWidth() - 4, 36, new Line("text.eyemod.notify_routerstorage"), false);
            this.currentApp.openPane(out);
        }
        return false;
    }

    public void onRefresh() {
        this.base.clear();
        this.initDevice();
        this.initApps();
    }

    public void onRefresh(App toOpen) {
        this.base.clear();
        this.initDevice();
        this.openApp(toOpen);
    }

    public void addNotification(ResourceLocation app, String notification) {
        if (!this.settings.getBool("notification")) {
            return;
        }
        if (!this.loaded_apps.containsKey(app)) {
            return;
        }
        notification = notification.replace("~", "-");
        String n = app + "~" + notification;
        this.data.addToList("notifications", (Tag)StringTag.m_129297_((String)n));
    }

    public ListTag getNotifications(ResourceLocation app) {
        ListTag not = new ListTag();
        ListTag no = this.data.getList("notifications", Naming.Type.STRING);
        for (int i = 0; i < no.size(); ++i) {
            String[] in;
            String s = no.m_128778_(i);
            if (!s.contains("~") || !(in = s.split("~"))[0].equals(app.toString())) continue;
            not.add((Object)no.get(i));
        }
        return not;
    }

    public void clearNotifications(ResourceLocation app) {
        if (app == null) {
            return;
        }
        ListTag not = this.getNotifications(app);
        ListTag no = this.data.getList("notifications", Naming.Type.STRING);
        if (!not.isEmpty()) {
            no.removeAll((Collection)not);
        }
        this.data.setList("notifications", no);
    }

    public boolean isInstalled(ResourceLocation app) {
        ListTag apps = this.data.getList("apps", Naming.Type.STRING);
        return apps.contains((Object)StringTag.m_129297_((String)(app.m_135827_() + ":" + app.m_135815_())));
    }

    public void deinstallApp(App app) {
        MinecraftForge.EVENT_BUS.post((Event)new EyeAppEvent(EyeEvents.EventSide.CLIENT, (Player)this.getUser(), this.getItem(), app, EyeEvents.AppAction.Deinstall));
        this.deinstallApp(app.getId());
    }

    private void deinstallApp(ResourceLocation app) {
        ListTag apps = this.data.getList("apps", Naming.Type.STRING);
        for (int i = 0; i < apps.size(); ++i) {
            if (!apps.m_128778_(i).equals(app.toString())) continue;
            apps.remove(i);
            if (!this.loaded_apps.containsKey(app)) break;
            this.data.addInt("money", this.loaded_apps.get(app).getPrice());
            break;
        }
        this.data.setList("apps", apps);
    }

    public boolean installApp(ResourceLocation app) {
        return this.installApp(EyeApps.getApp(app));
    }

    public boolean installApp(App app) {
        int money = this.data.getInt("money");
        if (money >= app.getPrice()) {
            MinecraftForge.EVENT_BUS.post((Event)new EyeAppEvent(EyeEvents.EventSide.CLIENT, (Player)this.getUser(), this.getItem(), app, EyeEvents.AppAction.Install));
            this.data.addInt("money", app.getPrice() * -1);
            this.data.addToList("apps", (Tag)StringTag.m_129297_((String)app.getId().toString()));
            return true;
        }
        return false;
    }

    public boolean addMoney(int amount) {
        ItemStack currency = this.getCurrency();
        int inv = this.getUser().m_150109_().m_18947_(currency.m_41720_());
        if (inv >= amount) {
            currency.m_41764_(amount);
            MinecraftForge.EVENT_BUS.post((Event)new EyeMoneyEvent(EyeEvents.EventSide.CLIENT, (Player)this.getUser(), this.getItem(), amount));
            PacketHandler.INSTANCE.sendToServer((Object)new ServerItemRemove(currency));
            this.data.setInt("money", this.data.getInt("money") + amount);
            return true;
        }
        return false;
    }

    public void addTimer(Timer t) {
        if (this.getUser().m_21120_(this.hand).m_41720_() instanceof ItemDevice) {
            ((ItemDevice)this.getUser().m_21120_((InteractionHand)this.hand).m_41720_()).timers.add(t);
        }
    }

    public void stopTimer(Timer t) {
        if (this.getUser().m_21120_(this.hand).m_41720_() instanceof ItemDevice) {
            ((ItemDevice)this.getUser().m_21120_((InteractionHand)this.hand).m_41720_()).timers.remove(t);
        }
    }

    public List<Timer> getTimers() {
        if (this.getUser().m_21120_(this.hand).m_41720_() instanceof ItemDevice) {
            return ((ItemDevice)this.getUser().m_21120_((InteractionHand)this.hand).m_41720_()).timers;
        }
        return null;
    }

    public String getUniqueID() {
        return this.data.getString("ID");
    }

    public App getOpenedApp() {
        return this.currentApp;
    }

    private void sendSpam(int range) {
        if (this.settings.getBool("spam")) {
            return;
        }
        int r = this.getUser().f_19853_.f_46441_.m_188503_(range * this.mails.length + range);
        if (r < this.mails.length && r >= 0) {
            String sen = this.mails[r][0];
            String sub = this.mails[r][1];
            String msg = this.applyMessage(this.mails[r][2]);
            this.connect.sendMail(sen, sub, msg);
        }
    }

    public String applyMessage(String msg) {
        if ((msg = msg.replace("{u}", this.getOwner())).contains("{ua}")) {
            ArrayList<String> un = new ArrayList<String>();
            for (ResourceLocation i : this.loaded_apps.keySet()) {
                if (this.getInstalledApps().contains(i)) continue;
                un.add(this.loaded_apps.get(i).getName().getText());
            }
            String name = "???";
            if (un.size() >= 1) {
                name = (String)un.get(this.getUser().f_19853_.f_46441_.m_188503_(un.size()));
            }
            msg = msg.replace("{ua}", name);
        }
        if (msg.contains("{ia}")) {
            String name = "???";
            int i = 0;
            int ra = this.getUser().f_19853_.f_46441_.m_188503_(this.loaded_apps.keySet().size());
            for (ResourceLocation id : this.loaded_apps.keySet()) {
                if (i == ra) {
                    name = this.loaded_apps.get(id).getName().getText();
                }
                ++i;
            }
            msg = msg.replace("{ia}", name);
        }
        return msg;
    }

    public int getTemp() {
        BlockPos bp = this.getUser().m_20183_();
        float t = ((Biome)this.getUser().f_19853_.m_204166_(bp).m_203334_()).m_47554_();
        return (int)(30.0f * t) + 2;
    }

    public String getWeather() {
        String weather = "text.eyemod.weather_sunny";
        BlockPos bp = this.getUser().m_20183_();
        boolean snow = ((Biome)this.getUser().f_19853_.m_204166_(bp).m_203334_()).m_198904_(bp);
        boolean rain = this.getUser().f_19853_.m_46471_();
        boolean thunder = this.getUser().f_19853_.m_46470_();
        if (rain) {
            String string = weather = snow ? "text.eyemod.weather_snowing" : "text.eyemod.weather_raining";
        }
        if (thunder) {
            weather = "text.eyemod.weather_thunder";
        }
        return weather;
    }

    public int getLastPage() {
        return this.lastPage;
    }

    public void setLastPage(int page) {
        this.lastPage = page;
    }
}

