/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.config;

import com.podloot.eyemod.config.EyeConfig;
import com.podloot.eyemod.gui.util.Naming;
import com.podloot.eyemod.lib.gui.EyeLib;
import com.podloot.eyemod.lib.gui.util.Pos;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class EyeConfigData {
    public CompoundTag data;

    public EyeConfigData() {
        this.data = this.toNbt();
    }

    public EyeConfigData(CompoundTag nbt) {
        this.data = nbt;
    }

    public CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        for (int i = 0; i < EyeConfig.keys.size(); ++i) {
            List list;
            Object value = EyeConfig.keys.get(i).get();
            String key = EyeConfig.keys.get(i).getPath().get(EyeConfig.keys.get(i).getPath().size() - 1).toString();
            if (value instanceof Integer) {
                nbt.m_128405_(key, ((Integer)value).intValue());
                continue;
            }
            if (value instanceof String) {
                nbt.m_128359_(key, (String)value);
                continue;
            }
            if (value instanceof Boolean) {
                nbt.m_128379_(key, ((Boolean)value).booleanValue());
                continue;
            }
            if (!(value instanceof ArrayList) || (list = (List)value).size() <= 0 || !(list.get(0) instanceof String)) continue;
            ListTag listTag = new ListTag();
            for (String s : list) {
                listTag.add((Object)StringTag.m_129297_((String)s));
            }
            nbt.m_128365_(key, (Tag)listTag);
        }
        return nbt;
    }

    public int getInt(String key) {
        return this.data.m_128451_(key);
    }

    public String getString(String key) {
        return this.data.m_128461_(key);
    }

    public boolean getBoolean(String key) {
        return this.data.m_128471_(key);
    }

    public String[] getList(String key) {
        ListTag tag = this.data.m_128437_(key, (int)Naming.Type.STRING.type);
        String[] list = new String[tag.size()];
        for (int i = 0; i < list.length; ++i) {
            list[i] = tag.m_128778_(i);
        }
        return list;
    }

    public int getAccess(String appid) {
        String[] access;
        for (String s : access = this.getList("app_access")) {
            String[] info;
            if (!s.contains("=") || (info = s.split("=")).length < 2 || !info[0].equals(appid)) continue;
            return EyeLib.getInt(info[1]);
        }
        return -1;
    }

    public int getPrice(String appid) {
        String[] access;
        for (String s : access = this.getList("app_price")) {
            String[] info;
            if (!s.contains("=") || (info = s.split("=")).length < 2 || !info[0].equals(appid)) continue;
            return EyeLib.getInt(info[1]);
        }
        return -1;
    }

    public ListTag getSpawns() {
        String[] spawns = this.getList("spawn_list");
        ListTag list = new ListTag();
        for (String s : spawns) {
            Pos p = new Pos().fromString(s);
            if (p.getPos() == null || p.getWorld() == null) continue;
            list.add((Object)StringTag.m_129297_((String)s));
        }
        return list;
    }
}

