/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.blocks.entities;

import com.podloot.eyemod.Eye;
import com.podloot.eyemod.blocks.Router;
import com.podloot.eyemod.gui.util.Naming;
import com.podloot.eyemod.items.ItemDevice;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class RouterEntity
extends BlockEntity {
    public int max_storage = 128;
    int steps = 43;
    int timer = 5;
    int max_time = 10;
    public CompoundTag data = new CompoundTag();
    public ListTag messages = new ListTag();
    public String owner = "";
    public String password = "";
    public int storage = 0;

    public RouterEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Eye.ROUTER_ENTITY.get(), pos, state);
        this.steps = this.max_storage / 4;
    }

    public void setData(int action, String key, Tag tag) {
        switch (action) {
            case 0: {
                if (this.storage >= this.max_storage || tag == null) break;
                this.data.m_128365_(key, tag);
                break;
            }
            case 1: {
                if (this.storage >= this.max_storage || tag == null) break;
                ListTag list = this.data.m_128437_(key, (int)tag.m_7060_());
                list.add((Object)tag);
                this.data.m_128365_(key, (Tag)list);
                break;
            }
            case 2: {
                this.data.m_128473_(key);
                break;
            }
            case 3: {
                ListTag rlist = (ListTag)this.data.m_128423_(key);
                if (tag.m_7060_() == Naming.Type.INT.type) {
                    rlist.remove(((IntTag)tag).m_7047_());
                } else {
                    rlist.remove((Object)tag);
                }
                this.data.m_128365_(key, (Tag)rlist);
                break;
            }
            case 4: {
                this.data = new CompoundTag();
                this.messages.clear();
                break;
            }
            case 5: {
                if (tag.m_7060_() != Naming.Type.COMPOUND.type) break;
                ListTag posts = this.data.m_128437_("posts", (int)Naming.Type.COMPOUND.type);
                CompoundTag reaction = (CompoundTag)tag;
                int index = reaction.m_128451_("i");
                String re = reaction.m_128461_("re");
                if (index >= posts.size() || index < 0) break;
                CompoundTag post = posts.m_128728_(index);
                ListTag res = post.m_128437_("re", (int)Naming.Type.STRING.type);
                res.add((Object)StringTag.m_129297_((String)re));
                post.m_128365_("re", (Tag)res);
                posts.remove(index);
                posts.add((Object)post);
                this.data.m_128365_("posts", (Tag)posts);
            }
        }
        this.update();
    }

    public void update() {
        this.storage = this.getDataStorage();
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 2);
    }

    public void recieveMessage(CompoundTag msg) {
        if (!msg.m_128441_("rec") || !msg.m_128441_("id")) {
            return;
        }
        msg.m_128405_("-t", 0);
        this.messages.add((Object)msg);
        if (this.messages.size() > this.max_storage) {
            this.removeMessage();
        }
        this.m_6596_();
    }

    public void removeMessage() {
        int oldest = 0;
        int index = -1;
        for (int i = 0; i < this.messages.size(); ++i) {
            if (this.messages.m_128728_(i).m_128451_("-t") <= oldest) continue;
            oldest = this.messages.m_128728_(i).m_128451_("-t");
            index = i;
        }
        if (index != -1) {
            this.messages.remove(index);
        }
    }

    public void tick() {
        if (this.timer <= 0) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            if (((Boolean)state.m_61143_((Property)Router.ON)).booleanValue()) {
                this.sendMessage();
                this.updateRouter();
            }
            this.timer = this.max_time;
        } else {
            --this.timer;
        }
    }

    public void sendMessage() {
        if (this.messages == null || this.messages.size() <= 0) {
            return;
        }
        CompoundTag msg = this.messages.m_128728_(0);
        msg.m_128405_("-t", msg.m_128451_("-t") + 1);
        this.messages.remove(0);
        ItemStack device = this.getPhone(msg.m_128461_("rec"));
        if (device != null) {
            ListTag msgs = device.m_41783_().m_128437_("_msgs", (int)Naming.Type.COMPOUND.type);
            msg.m_128473_("-t");
            msg.m_128473_("rec");
            msgs.add((Object)msg);
            device.m_41783_().m_128365_("_msgs", (Tag)msgs);
        } else {
            this.messages.add((Object)msg);
        }
        this.m_6596_();
    }

    public void updateRouter() {
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        int tot = this.messages.size();
        if (tot >= this.steps && tot <= this.steps * 3) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)((BlockState)state.m_61124_((Property)Router.SMOKE, (Comparable)Boolean.valueOf(true))).m_61124_((Property)Router.FIRE, (Comparable)Boolean.valueOf(false)));
            this.max_time = 10;
        } else if (tot > this.steps * 3) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)((BlockState)state.m_61124_((Property)Router.SMOKE, (Comparable)Boolean.valueOf(true))).m_61124_((Property)Router.FIRE, (Comparable)Boolean.valueOf(true)));
            this.max_time = 20;
        } else {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)((BlockState)state.m_61124_((Property)Router.SMOKE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)Router.FIRE, (Comparable)Boolean.valueOf(false)));
            this.max_time = 5;
        }
    }

    public int getDataStorage() {
        int storage = 0;
        for (String k : this.data.m_128431_()) {
            if (this.data.m_128423_(k).m_7060_() == Naming.Type.LIST.type) {
                if (k.equals("posts")) {
                    storage += this.getPostSize((ListTag)this.data.m_128423_(k));
                    continue;
                }
                storage += ((ListTag)this.data.m_128423_(k)).size();
                continue;
            }
            if (this.data.m_128423_(k).m_7060_() == Naming.Type.COMPOUND.type) {
                storage += this.data.m_128469_(k).m_128440_();
                continue;
            }
            if (this.data.m_128423_(k).m_7060_() == Naming.Type.INTARRAY.type) {
                storage += this.data.m_128465_(k).length;
                continue;
            }
            ++storage;
        }
        return storage;
    }

    public int getPostSize(ListTag post) {
        int r = 0;
        for (int i = 0; i < post.size(); ++i) {
            ++r;
            if (!post.m_128728_(i).m_128441_("re")) continue;
            r += post.m_128728_(i).m_128437_("re", (int)Naming.Type.STRING.type).size();
        }
        return r;
    }

    private ItemStack getPhone(String name) {
        if (this.f_58857_.m_5776_()) {
            return null;
        }
        if (this.f_58857_.m_7654_() == null) {
            return null;
        }
        for (Level w : this.f_58857_.m_7654_().m_129785_()) {
            for (Player player : w.m_6907_()) {
                ArrayList stacks = new ArrayList();
                stacks.addAll(player.m_150109_().f_35974_);
                stacks.addAll(player.m_150109_().f_35976_);
                for (ItemStack s : stacks) {
                    if (!(s.m_41720_() instanceof ItemDevice) || !s.m_41783_().m_128461_("user").equals(name)) continue;
                    return s;
                }
            }
        }
        return null;
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128365_("rdata", (Tag)this.data);
        nbt.m_128365_("rmsg", (Tag)this.messages);
        nbt.m_128359_("owner", this.owner);
        nbt.m_128359_("password", this.password);
        nbt.m_128405_("storage", this.storage);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.data = nbt.m_128469_("rdata");
        this.messages = nbt.m_128437_("rmsg", (int)Naming.Type.COMPOUND.type);
        this.owner = nbt.m_128461_("owner");
        this.password = nbt.m_128461_("password");
        this.storage = nbt.m_128451_("storage");
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }
}

