/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod;

import com.mojang.logging.LogUtils;
import com.podloot.eyemod.EyeClient;
import com.podloot.eyemod.blocks.Charger;
import com.podloot.eyemod.blocks.Router;
import com.podloot.eyemod.blocks.entities.RouterEntity;
import com.podloot.eyemod.config.EyeConfig;
import com.podloot.eyemod.gui.util.messages.EyeMsgHandler;
import com.podloot.eyemod.items.ItemPhone;
import com.podloot.eyemod.network.PacketHandler;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

@Mod(value="eyemod")
public class Eye {
    public static final String MODID = "eyemod";
    public static final String VERSION = "1";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"eyemod");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"eyemod");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"eyemod");
    public static final RegistryObject<Block> ROUTER = BLOCKS.register("router", () -> new Router(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_)));
    public static final RegistryObject<Item> ROUTER_ITEM = ITEMS.register("router", () -> new BlockItem((Block)ROUTER.get(), new Item.Properties().m_41491_(CreativeModeTab.f_40749_)));
    public static final RegistryObject<Block> CHARGER = BLOCKS.register("charger", () -> new Charger(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60977_()));
    public static final RegistryObject<Item> CHARGER_ITEM = ITEMS.register("charger", () -> new BlockItem((Block)CHARGER.get(), new Item.Properties().m_41491_(CreativeModeTab.f_40749_)));
    public static final RegistryObject<Item> EYEPHONE = ITEMS.register("eyephone", () -> new ItemPhone(new Item.Properties().m_41491_(CreativeModeTab.f_40756_).m_41503_(256)));
    public static final RegistryObject<Item> EYECORE = ITEMS.register("eyecore", () -> new Item(new Item.Properties().m_41491_(CreativeModeTab.f_40753_)));
    public static final RegistryObject<Item> DISPLAY = ITEMS.register("display", () -> new Item(new Item.Properties().m_41491_(CreativeModeTab.f_40753_)));
    public static final RegistryObject<Item> COVER = ITEMS.register("cover", () -> new Item(new Item.Properties().m_41491_(CreativeModeTab.f_40753_)));
    public static final RegistryObject<Item> BATTERY = ITEMS.register("battery", () -> new Item(new Item.Properties().m_41491_(CreativeModeTab.f_40753_)));
    public static final RegistryObject<Item> DRIVE = ITEMS.register("drive", () -> new Item(new Item.Properties().m_41491_(CreativeModeTab.f_40753_)));
    public static final RegistryObject<Item> WIRE = ITEMS.register("wire", () -> new Item(new Item.Properties().m_41491_(CreativeModeTab.f_40753_)));
    public static final RegistryObject<BlockEntityType<RouterEntity>> ROUTER_ENTITY = BLOCK_ENTITIES.register("router_entity", () -> BlockEntityType.Builder.m_155273_(RouterEntity::new, (Block[])new Block[]{(Block)ROUTER.get()}).m_58966_(null));

    public Eye() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        BLOCK_ENTITIES.register(modEventBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)EyeConfig.SPEC, "eyemod-config.toml");
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(PacketHandler::init);
        event.enqueueWork(EyeMsgHandler::init);
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @Mod.EventBusSubscriber(modid="eyemod", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            EyeClient.onInitializeClient();
        }
    }
}

