/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.server.events.broadcast.producer.transmitter;

import io.github.tofodroid.mods.mimi.common.MIMIMod;
import io.github.tofodroid.mods.mimi.common.api.event.broadcast.IBroadcastProducer;
import io.github.tofodroid.mods.mimi.common.config.ConfigProxy;
import io.github.tofodroid.mods.mimi.common.midi.BasicMidiInfo;
import io.github.tofodroid.mods.mimi.common.network.ServerMusicPlayerSongListPacket;
import io.github.tofodroid.mods.mimi.common.network.ServerMusicPlayerStatusPacket;
import io.github.tofodroid.mods.mimi.common.network.TransmitterControlPacket;
import io.github.tofodroid.mods.mimi.common.tile.TileTransmitter;
import io.github.tofodroid.mods.mimi.server.events.broadcast.BroadcastManager;
import io.github.tofodroid.mods.mimi.server.events.broadcast.producer.transmitter.ATransmitterBroadcastProducer;
import io.github.tofodroid.mods.mimi.server.events.broadcast.producer.transmitter.PlayerTransmitterBroadcastProducer;
import io.github.tofodroid.mods.mimi.server.events.broadcast.producer.transmitter.TileTransmitterBroadcastProducer;
import io.github.tofodroid.mods.mimi.server.network.ServerMidiUploadManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.sound.midi.Sequence;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public abstract class ServerTransmitterManager {
    private static final Map<UUID, Set<UUID>> MIDI_LOAD_CACHE_MAP = new HashMap<UUID, Set<UUID>>();
    private static ExecutorService pool;
    private static ExecutorService executor;
    private static Boolean shuttingDown;

    private static void logMidiTaskError(String error, Exception e) {
        if (ConfigProxy.getDoLogMidiTaskErrors().booleanValue()) {
            MIMIMod.LOGGER.warn("MIDI task timed out. This usually indiciates performance trouble. Task: " + error, (Throwable)e);
        }
    }

    public static ATransmitterBroadcastProducer getTransmitter(UUID id) {
        IBroadcastProducer producer = BroadcastManager.getBroadcastProducer(id);
        if (producer instanceof ATransmitterBroadcastProducer) {
            return (ATransmitterBroadcastProducer)producer;
        }
        return null;
    }

    public static PlayerTransmitterBroadcastProducer createTransmitter(ServerPlayer player) {
        return BroadcastManager.registerProducer(new PlayerTransmitterBroadcastProducer(player));
    }

    public static TileTransmitterBroadcastProducer createTransmitter(TileTransmitter tile) {
        return BroadcastManager.registerProducer(new TileTransmitterBroadcastProducer(tile));
    }

    public static void executeTaskOnMidiThread(Runnable runnable, Consumer<Exception> onFailed) {
        ServerTransmitterManager.configureMidiThread();
        if (!shuttingDown.booleanValue() && pool != null && executor != null) {
            pool.execute(() -> {
                Future<?> future = executor.submit(runnable);
                try {
                    future.get(ConfigProxy.getMidiTaskTimeoutMillis().intValue(), TimeUnit.MILLISECONDS);
                }
                catch (Exception e) {
                    future.cancel(true);
                    onFailed.accept(e);
                }
            });
        }
    }

    public static void configureMidiThread() {
        if (!shuttingDown.booleanValue()) {
            if (pool == null) {
                pool = Executors.newFixedThreadPool(1);
            }
            if (executor == null) {
                executor = Executors.newSingleThreadExecutor();
            }
        }
    }

    public static void onServerAboutToStart() {
        shuttingDown = false;
    }

    public static void onServerStopping() {
        shuttingDown = true;
        if (pool != null) {
            pool.shutdown();
            try {
                pool.awaitTermination(5000L, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                MIMIMod.LOGGER.error("Failed to orderly shutdown MIDI pool. Error: " + e.getMessage());
                try {
                    pool.shutdownNow();
                    pool.awaitTermination(5000L, TimeUnit.MILLISECONDS);
                }
                catch (Exception e2) {
                    MIMIMod.LOGGER.error("Failed to force shutdown MIDI pool. Error: " + e.getMessage());
                }
            }
            pool = null;
        }
        if (executor != null) {
            executor.shutdown();
            try {
                executor.awaitTermination(5000L, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                MIMIMod.LOGGER.error("Failed to orderly shutdown MIDI executor. Error: " + e.getMessage());
                try {
                    executor.shutdownNow();
                    executor.awaitTermination(5000L, TimeUnit.MILLISECONDS);
                }
                catch (Exception e2) {
                    MIMIMod.LOGGER.error("Failed to force shutdown MIDI executor. Error: " + e.getMessage());
                }
            }
            executor = null;
        }
    }

    public static ServerMusicPlayerSongListPacket createListPacket(UUID musicPlayerId) {
        ATransmitterBroadcastProducer transmitter = ServerTransmitterManager.getTransmitter(musicPlayerId);
        if (transmitter != null) {
            return new ServerMusicPlayerSongListPacket(musicPlayerId, transmitter.getCurrentSongsSorted(), transmitter.getCurrentFavoriteIndicies());
        }
        return null;
    }

    public static ServerMusicPlayerStatusPacket createStatusPacket(UUID musicPlayerId) {
        ATransmitterBroadcastProducer transmitter = ServerTransmitterManager.getTransmitter(musicPlayerId);
        if (transmitter != null) {
            return transmitter.getStatus();
        }
        return null;
    }

    public static Boolean handleCommand(TransmitterControlPacket message) {
        ATransmitterBroadcastProducer musicPlayer = ServerTransmitterManager.getTransmitter(message.transmitterId);
        Boolean shouldRefreshSongs = false;
        if (musicPlayer != null) {
            switch (message.control) {
                case PLAY: {
                    ServerTransmitterManager.executeTaskOnMidiThread(() -> musicPlayer.play(), e -> ServerTransmitterManager.logMidiTaskError("Failed to play transmitter: " + musicPlayer.getOwnerId().toString(), e));
                    break;
                }
                case PAUSE: {
                    ServerTransmitterManager.executeTaskOnMidiThread(() -> musicPlayer.pause(), e -> ServerTransmitterManager.logMidiTaskError("Failed to pause transmitter: " + musicPlayer.getOwnerId().toString(), e));
                    break;
                }
                case STOP: {
                    ServerTransmitterManager.executeTaskOnMidiThread(() -> musicPlayer.stop(), e -> ServerTransmitterManager.logMidiTaskError("Failed to stop transmitter: " + musicPlayer.getOwnerId().toString(), e));
                    break;
                }
                case RESTART: {
                    ServerTransmitterManager.executeTaskOnMidiThread(() -> {
                        musicPlayer.stop();
                        musicPlayer.play();
                    }, e -> ServerTransmitterManager.logMidiTaskError("Failed to restart transmitter: " + musicPlayer.getOwnerId().toString(), e));
                    break;
                }
                case SEEK: {
                    ServerTransmitterManager.executeTaskOnMidiThread(() -> musicPlayer.seek(message.controlData.get()), e -> ServerTransmitterManager.logMidiTaskError("Failed to seek transmitter: " + musicPlayer.getOwnerId().toString(), e));
                    break;
                }
                case PREV: {
                    musicPlayer.previous();
                    break;
                }
                case NEXT: {
                    musicPlayer.next();
                    break;
                }
                case SHUFFLE: {
                    musicPlayer.toggleShuffled();
                    shouldRefreshSongs = true;
                    break;
                }
                case LOOP_M: {
                    musicPlayer.cycleLoopMode();
                    break;
                }
                case FAVE_M: {
                    musicPlayer.cycleFavoriteMode();
                    shouldRefreshSongs = true;
                    break;
                }
                case SOURCE_M: {
                    musicPlayer.cycleSourceMode();
                    shouldRefreshSongs = true;
                    break;
                }
                case MARKFAVE: {
                    musicPlayer.toggleSongFavorite();
                    shouldRefreshSongs = true;
                    break;
                }
            }
            return shouldRefreshSongs;
        }
        return false;
    }

    public static void refreshSongs(UUID playerId) {
        ServerTransmitterManager.executeTaskOnMidiThread(() -> {
            ATransmitterBroadcastProducer handler = ServerTransmitterManager.getTransmitter(playerId);
            if (handler != null) {
                handler.refreshSongs();
            }
        }, e -> ServerTransmitterManager.logMidiTaskError("Failed to refresh transmitter songs for ID: " + playerId.toString(), e));
    }

    public static void onServerSongsRefreshed() {
        ServerTransmitterManager.executeTaskOnMidiThread(() -> {
            for (ATransmitterBroadcastProducer transmitter : BroadcastManager.getBroadcastProducersByType(ATransmitterBroadcastProducer.class)) {
                transmitter.refreshSongs();
            }
        }, e -> ServerTransmitterManager.logMidiTaskError("Failed to refresh transmitter songs", e));
    }

    public static void onSelectedSongChange(UUID musicPlayerId, BasicMidiInfo newInfo) {
        ATransmitterBroadcastProducer player = ServerTransmitterManager.getTransmitter(musicPlayerId);
        if (player != null) {
            ServerTransmitterManager.executeTaskOnMidiThread(() -> player.loadSong(newInfo), e -> ServerTransmitterManager.logMidiTaskError("Failed to load song into transmitter with ID: " + String.valueOf(musicPlayerId), e));
        }
    }

    public static void startLoadSequence(UUID musicPlayerId, UUID clientId, BasicMidiInfo info) {
        if (MIDI_LOAD_CACHE_MAP.containsKey(info.fileId)) {
            MIDI_LOAD_CACHE_MAP.get(info.fileId).add(musicPlayerId);
        } else {
            MIDI_LOAD_CACHE_MAP.put(info.fileId, new HashSet());
            MIDI_LOAD_CACHE_MAP.get(info.fileId).add(musicPlayerId);
            ServerMidiUploadManager.startUploadRequest(clientId, info);
        }
    }

    public static void onSequenceUploadFailed(BasicMidiInfo info) {
        if (MIDI_LOAD_CACHE_MAP.containsKey(info.fileId)) {
            for (UUID musicPlayerId : MIDI_LOAD_CACHE_MAP.get(info.fileId)) {
                ATransmitterBroadcastProducer player = ServerTransmitterManager.getTransmitter(musicPlayerId);
                if (player == null) continue;
                player.onSequenceLoadFailed(info);
            }
            MIDI_LOAD_CACHE_MAP.remove(info.fileId);
        }
    }

    public static void onFinishUploadSequence(BasicMidiInfo info, Sequence sequence) {
        if (MIDI_LOAD_CACHE_MAP.containsKey(info.fileId)) {
            for (UUID musicPlayerId : MIDI_LOAD_CACHE_MAP.get(info.fileId)) {
                ATransmitterBroadcastProducer player = ServerTransmitterManager.getTransmitter(musicPlayerId);
                if (player == null) continue;
                ServerTransmitterManager.executeTaskOnMidiThread(() -> player.finishLoadSequence(info, sequence), e -> ServerTransmitterManager.logMidiTaskError("Failed to load song into transmitter with ID: " + String.valueOf(musicPlayerId), e));
            }
            MIDI_LOAD_CACHE_MAP.remove(info.fileId);
        }
    }

    public static void onLivingDeath(LivingEntity entity) {
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerTransmitterManager.executeTaskOnMidiThread(() -> {
            ATransmitterBroadcastProducer transmitter = ServerTransmitterManager.getTransmitter(entity.m_20148_());
            if (transmitter != null) {
                transmitter.stop();
            }
        }, e -> ServerTransmitterManager.logMidiTaskError("Failed to stop transmitter with ID: " + String.valueOf(entity.m_20148_()), e));
    }

    public static void onEntityChangeDimension(Entity entity) {
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerTransmitterManager.executeTaskOnMidiThread(() -> {
            ATransmitterBroadcastProducer transmitter = ServerTransmitterManager.getTransmitter(entity.m_20148_());
            if (transmitter != null) {
                transmitter.reset();
            }
        }, e -> ServerTransmitterManager.logMidiTaskError("Failed to silence transmitter with ID: " + String.valueOf(entity.m_20148_()), e));
    }

    public static void onEntityTeleport(Entity entity) {
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerTransmitterManager.executeTaskOnMidiThread(() -> {
            ATransmitterBroadcastProducer transmitter = ServerTransmitterManager.getTransmitter(entity.m_20148_());
            if (transmitter != null) {
                transmitter.reset();
            }
        }, e -> ServerTransmitterManager.logMidiTaskError("Failed to stop transmitter with ID: " + String.valueOf(entity.m_20148_()), e));
    }

    public static void onPlayerLoggedIn(ServerPlayer player) {
        ServerTransmitterManager.createTransmitter(player);
    }

    public static void onPlayerLoggedOut(ServerPlayer player) {
        if (player.m_9236_() instanceof ServerLevel) {
            BroadcastManager.removeBroadcastProducer(player.m_20148_());
        }
    }

    static {
        shuttingDown = false;
    }
}

