/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.forge.common;

import io.github.tofodroid.mods.mimi.common.world.ModStructures;
import io.github.tofodroid.mods.mimi.server.events.ServerEventHandler;
import io.github.tofodroid.mods.mimi.server.events.broadcast.BroadcastManager;
import io.github.tofodroid.mods.mimi.server.events.broadcast.consumer.instrument.EntityInstrumentConsumerEventHandler;
import io.github.tofodroid.mods.mimi.server.events.broadcast.producer.transmitter.ServerTransmitterManager;
import io.github.tofodroid.mods.mimi.server.events.note.consumer.ServerNoteConsumer;
import io.github.tofodroid.mods.mimi.server.events.note.consumer.ServerNoteConsumerManager;
import io.github.tofodroid.mods.mimi.server.midi.ServerMidiManager;
import io.github.tofodroid.mods.mimi.server.network.ServerMidiUploadManager;
import net.minecraft.core.Registry;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="mimi", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CommonForgeEventHandler {
    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!(event.getEntity() instanceof ServerPlayer)) {
            return;
        }
        ServerEventHandler.onPlayerLoggedIn((ServerPlayer)event.getEntity());
        ServerMidiManager.onPlayerLoggedIn((ServerPlayer)event.getEntity());
        ServerTransmitterManager.onPlayerLoggedIn((ServerPlayer)event.getEntity());
        EntityInstrumentConsumerEventHandler.onPlayerLoggedIn((ServerPlayer)event.getEntity());
        ServerNoteConsumerManager.onPlayerLoggedIn((ServerPlayer)event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (!(event.getEntity() instanceof ServerPlayer)) {
            return;
        }
        ServerMidiManager.onPlayerLoggedOut((ServerPlayer)event.getEntity());
        ServerTransmitterManager.onPlayerLoggedOut((ServerPlayer)event.getEntity());
        EntityInstrumentConsumerEventHandler.onPlayerLoggedOut((ServerPlayer)event.getEntity());
        ServerNoteConsumerManager.onPlayerLoggedOut((ServerPlayer)event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (!(event.getEntity() instanceof ServerPlayer)) {
            return;
        }
        EntityInstrumentConsumerEventHandler.onPlayerRespawn((ServerPlayer)event.getEntity());
        ServerNoteConsumerManager.onPlayerRespawn((ServerPlayer)event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.side != LogicalSide.SERVER || !(event.player instanceof ServerPlayer)) {
            return;
        }
    }

    @SubscribeEvent
    public static void onLivingEquipmentChange(LivingEquipmentChangeEvent event) {
        if (!(event.getEntity().m_9236_() instanceof ServerLevel)) {
            return;
        }
        EntityInstrumentConsumerEventHandler.onLivingEquipmentChange(event.getFrom(), event.getTo(), event.getEntity());
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        if (!(event.getEntity().m_9236_() instanceof ServerLevel)) {
            return;
        }
        EntityInstrumentConsumerEventHandler.onLivingDeath(event.getEntity());
        ServerTransmitterManager.onLivingDeath(event.getEntity());
    }

    @SubscribeEvent
    public static void onEntityTeleport(EntityTeleportEvent event) {
        if (!(event.getEntity().m_9236_() instanceof ServerLevel)) {
            return;
        }
        EntityInstrumentConsumerEventHandler.onEntityTeleport(event.getEntity());
        ServerTransmitterManager.onEntityTeleport(event.getEntity());
    }

    @SubscribeEvent
    public static void onEntityChangeDimension(EntityTravelToDimensionEvent event) {
        if (!(event.getEntity().m_9236_() instanceof ServerLevel)) {
            return;
        }
        EntityInstrumentConsumerEventHandler.onEntityChangeDimension(event.getEntity());
        ServerTransmitterManager.onEntityChangeDimension(event.getEntity());
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.side != LogicalSide.SERVER) {
            return;
        }
        BroadcastManager.onServerTick();
        ServerNoteConsumerManager.onServerTick();
        ServerNoteConsumer.onServerTick();
        ServerMidiUploadManager.onServerTick();
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        BroadcastManager.onServerStopping();
        ServerTransmitterManager.onServerStopping();
    }

    @SubscribeEvent
    public static void onServerAboutToStart(ServerAboutToStartEvent event) {
        ModStructures.registerVillageStructures((Registry<StructureProcessorList>)((Registry)event.getServer().m_206579_().m_6632_(Registry.f_122883_).orElseThrow()), (Registry<StructureTemplatePool>)((Registry)event.getServer().m_206579_().m_6632_(Registry.f_122884_).orElseThrow()));
        ServerTransmitterManager.onServerAboutToStart();
    }
}

