/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.tile;

import io.github.tofodroid.mods.mimi.common.block.BlockTransmitter;
import io.github.tofodroid.mods.mimi.common.tile.AConfigurableMidiTile;
import io.github.tofodroid.mods.mimi.common.tile.ModTiles;
import io.github.tofodroid.mods.mimi.server.events.broadcast.BroadcastManager;
import io.github.tofodroid.mods.mimi.server.events.broadcast.producer.transmitter.ServerTransmitterManager;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TileTransmitter
extends AConfigurableMidiTile {
    public static final String REGISTRY_NAME = "transmitter";
    private UUID id;

    public TileTransmitter(BlockPos pos, BlockState state) {
        super(ModTiles.TRANSMITTER, pos, state, 1);
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (this.m_58898_() && !this.m_58904_().f_46443_ && !this.getSourceStack().m_41619_()) {
            ServerTransmitterManager.createTransmitter(this);
            this.setUnpowered();
        }
    }

    public void onLoad() {
        super.onLoad();
        if (this.m_58898_() && !this.m_58904_().f_46443_ && !this.getSourceStack().m_41619_()) {
            ServerTransmitterManager.createTransmitter(this);
            this.setUnpowered();
        }
    }

    public void m_7651_() {
        super.m_7651_();
        if (!this.m_58904_().m_5776_()) {
            BroadcastManager.removeBroadcastProducer(this.getUUID());
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (!this.m_58904_().m_5776_()) {
            BroadcastManager.removeBroadcastProducer(this.getUUID());
        }
    }

    @Override
    public UUID getUUID() {
        if (this.id == null) {
            String idString = "tile-transmitter-" + this.m_58899_().m_123341_() + "-" + this.m_58899_().m_123342_() + "-" + this.m_58899_().m_123343_();
            this.id = UUID.nameUUIDFromBytes(idString.getBytes());
        }
        return this.id;
    }

    public Boolean isPowered() {
        return (Boolean)this.m_58900_().m_61143_((Property)BlockTransmitter.POWERED);
    }

    public void setPowered() {
        this.setPowerAndUpdate(true);
    }

    public void setUnpowered() {
        this.setPowerAndUpdate(false);
    }

    protected void setPowerAndUpdate(Boolean powered) {
        this.m_58904_().m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)BlockTransmitter.POWERED, (Comparable)powered));
        this.m_58904_().m_46717_(this.f_58858_, this.m_58900_().m_60734_());
    }
}

