/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.tile;

import io.github.tofodroid.mods.mimi.common.api.event.broadcast.BroadcastConsumerInventoryHolder;
import io.github.tofodroid.mods.mimi.common.block.BlockMechanicalMaestro;
import io.github.tofodroid.mods.mimi.common.container.ContainerMechanicalMaestro;
import io.github.tofodroid.mods.mimi.common.item.IInstrumentItem;
import io.github.tofodroid.mods.mimi.common.network.NoteEventPacket;
import io.github.tofodroid.mods.mimi.common.tile.AContainerTile;
import io.github.tofodroid.mods.mimi.common.tile.ModTiles;
import io.github.tofodroid.mods.mimi.server.events.broadcast.BroadcastManager;
import io.github.tofodroid.mods.mimi.server.events.broadcast.consumer.instrument.InstrumentBroadcastConsumer;
import io.github.tofodroid.mods.mimi.server.events.note.consumer.ServerNoteConsumerManager;
import io.github.tofodroid.mods.mimi.util.MidiNbtDataUtils;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TileMechanicalMaestro
extends AContainerTile {
    public static final String REGISTRY_NAME = "mechanicalmaestro";
    private UUID id;

    public TileMechanicalMaestro(BlockPos pos, BlockState state) {
        super(ModTiles.MECHANICALMAESTRO, pos, state, 3);
    }

    public UUID getUUID() {
        if (this.id == null) {
            String idString = ((Object)((Object)this)).getClass().getSimpleName() + this.m_58899_().m_123341_() + "-" + this.m_58899_().m_123342_() + "-" + this.m_58899_().m_123343_();
            this.id = UUID.nameUUIDFromBytes(idString.getBytes());
        }
        return this.id;
    }

    public Component m_6820_() {
        return Component.m_237115_((String)this.m_58900_().m_60734_().m_5456_().m_5524_());
    }

    public AbstractContainerMenu m_6555_(int id, Inventory playerInventory) {
        return new ContainerMechanicalMaestro(id, playerInventory, (Container)this);
    }

    @Override
    public void m_6836_(int i, ItemStack item) {
        ItemStack oldStack = this.m_8020_(i);
        if (!oldStack.m_41619_()) {
            this.reset(((IInstrumentItem)oldStack.m_41720_()).getInstrumentId());
        }
        super.m_6836_(i, item);
        this.refreshMidiReceivers();
    }

    @Override
    public ItemStack m_7407_(int i, int count) {
        ItemStack result = super.m_7407_(i, count);
        this.reset(((IInstrumentItem)result.m_41720_()).getInstrumentId());
        this.refreshMidiReceivers();
        return result;
    }

    @Override
    public ItemStack m_8016_(int i) {
        ItemStack result = super.m_8016_(i);
        this.reset(((IInstrumentItem)result.m_41720_()).getInstrumentId());
        this.refreshMidiReceivers();
        return result;
    }

    @Override
    public void m_6211_() {
        this.reset();
        super.m_6211_();
        BroadcastManager.removeOwnedBroadcastConsumers(this.getUUID());
    }

    @Override
    public void onAddedToLevel() {
        this.refreshMidiReceivers();
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.refreshMidiReceivers();
    }

    public void onLoad() {
        super.onLoad();
        this.refreshMidiReceivers();
    }

    public void m_7651_() {
        super.m_7651_();
        if (!this.m_58904_().m_5776_()) {
            this.reset();
            BroadcastManager.removeOwnedBroadcastConsumers(this.getUUID());
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (!this.m_58904_().m_5776_()) {
            this.reset();
            BroadcastManager.removeOwnedBroadcastConsumers(this.getUUID());
        }
    }

    @Override
    public boolean m_7155_(int slot, ItemStack stack, @Nullable Direction side) {
        return stack.m_41720_() instanceof IInstrumentItem;
    }

    public List<ItemStack> getInstrumentStacks() {
        return this.getItems().stream().filter(stack -> stack.m_41720_() instanceof IInstrumentItem).collect(Collectors.toList());
    }

    public Boolean hasAnInstrument() {
        return this.getItems().stream().anyMatch(i -> i.m_41720_() instanceof IInstrumentItem);
    }

    public void reset() {
        this.getItems().stream().forEach(i -> {
            if (i.m_41720_() instanceof IInstrumentItem) {
                this.reset(((IInstrumentItem)i.m_41720_()).getInstrumentId());
            }
        });
    }

    public void reset(Byte instrumentId) {
        if (instrumentId != null && this.m_58904_() instanceof ServerLevel) {
            ServerNoteConsumerManager.handlePacket(NoteEventPacket.createResetPacket(instrumentId, this.getUUID(), this.m_58899_(), null), false, this.getUUID(), (ServerLevel)this.m_58904_());
        }
    }

    public void refreshMidiReceivers() {
        if (this.m_58898_() && !this.f_58857_.f_46443_) {
            if (this.hasAnInstrument().booleanValue() && ((Boolean)this.m_58900_().m_61143_((Property)BlockMechanicalMaestro.POWERED)).booleanValue()) {
                BroadcastConsumerInventoryHolder holder = new BroadcastConsumerInventoryHolder(this.getUUID());
                for (int i = 0; i < this.getInstrumentStacks().size(); ++i) {
                    ItemStack instrumentStack = this.getInstrumentStacks().get(i);
                    if (instrumentStack == null || MidiNbtDataUtils.getMidiSource(instrumentStack) == null) continue;
                    holder.putConsumer(i, new InstrumentBroadcastConsumer(this.m_58899_(), (ResourceKey<Level>)this.m_58904_().m_46472_(), this.getUUID(), instrumentStack, null));
                }
                BroadcastManager.removeOwnedBroadcastConsumers(this.getUUID());
                BroadcastManager.registerConsumers(holder);
            } else {
                this.reset();
                BroadcastManager.removeOwnedBroadcastConsumers(this.getUUID());
            }
        }
    }
}

