/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.tile;

import com.mojang.math.Vector3d;
import io.github.tofodroid.mods.mimi.common.block.BlockInstrument;
import io.github.tofodroid.mods.mimi.common.entity.EntitySeat;
import io.github.tofodroid.mods.mimi.common.item.IColorableItem;
import io.github.tofodroid.mods.mimi.common.tile.AConfigurableTile;
import io.github.tofodroid.mods.mimi.common.tile.ModTiles;
import io.github.tofodroid.mods.mimi.server.events.broadcast.consumer.instrument.EntityInstrumentConsumerEventHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TileInstrument
extends AConfigurableTile {
    public static final String REGISTRY_NAME = "instrument";
    public static final String COLOR_TAG = "color";
    protected EntitySeat currentSeat = null;
    protected Integer color;

    public TileInstrument(BlockPos pos, BlockState state) {
        super(ModTiles.INSTRUMENT, pos, state, 1);
    }

    public void attemptSit(Player player) {
        if (player.m_9236_().f_46443_) {
            return;
        }
        EntitySeat newSeat = EntitySeat.create(player.m_9236_(), this.m_58899_(), this.getSeatOffset(this.m_58900_()), player);
        if (newSeat != null) {
            this.currentSeat = newSeat;
        }
    }

    public void ejectPlayer() {
        if (this.currentSeat != null && !this.currentSeat.m_213877_()) {
            this.currentSeat.m_20153_();
            this.currentSeat.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public Player getCurrentPlayer() {
        if (this.currentSeat != null && !this.currentSeat.m_213877_()) {
            return this.currentSeat.getRider();
        }
        return null;
    }

    protected Vector3d getSeatOffset(BlockState state) {
        switch ((Direction)state.m_61143_((Property)BlockInstrument.DIRECTION)) {
            case NORTH: {
                return new Vector3d(0.5, 0.0, 0.05);
            }
            case SOUTH: {
                return new Vector3d(0.5, 0.0, 0.95);
            }
            case EAST: {
                return new Vector3d(0.95, 0.0, 0.5);
            }
            case WEST: {
                return new Vector3d(0.05, 0.0, 0.5);
            }
        }
        return new Vector3d(0.5, 0.0, 0.05);
    }

    @Override
    protected void onSourceStackChanged() {
        Player currentPlayer;
        if (this.blockInstrument().isColorable().booleanValue() && this.getSourceStack().m_41720_() instanceof IColorableItem && ((IColorableItem)this.getSourceStack().m_41720_()).hasColor(this.getSourceStack())) {
            this.color = ((IColorableItem)this.getSourceStack().m_41720_()).m_41121_(this.getSourceStack());
        }
        if ((currentPlayer = this.getCurrentPlayer()) != null) {
            EntityInstrumentConsumerEventHandler.reloadEntityInstrumentConsumers((LivingEntity)currentPlayer);
        }
    }

    public void m_7651_() {
        super.m_7651_();
        Player currentPlayer = this.getCurrentPlayer();
        if (currentPlayer != null && !this.m_58904_().m_5776_()) {
            this.ejectPlayer();
            EntityInstrumentConsumerEventHandler.reloadEntityInstrumentConsumers((LivingEntity)currentPlayer);
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        Player currentPlayer = this.getCurrentPlayer();
        if (currentPlayer != null && !this.m_58904_().m_5776_()) {
            this.ejectPlayer();
            EntityInstrumentConsumerEventHandler.reloadEntityInstrumentConsumers((LivingEntity)currentPlayer);
        }
    }

    public Byte getInstrumentId() {
        return this.blockInstrument().getInstrumentId();
    }

    public Boolean hasColor() {
        return this.color != null && this.blockInstrument().isColorable() != false;
    }

    public Integer getColor() {
        if (!this.blockInstrument().isColorable().booleanValue()) {
            return -1;
        }
        return this.hasColor() != false ? this.color : this.blockInstrument().getDefaultColor();
    }

    private BlockInstrument blockInstrument() {
        return (BlockInstrument)this.m_58900_().m_60734_();
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        if (this.color != null) {
            compound.m_128405_(COLOR_TAG, this.color.intValue());
        }
    }

    @Override
    public void onItemsLoaded() {
        super.onItemsLoaded();
        this.onSourceStackChanged();
    }

    public BlockPos m_58899_() {
        return this.f_58858_;
    }
}

