/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.tile;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AContainerTile
extends BaseContainerBlockEntity
implements WorldlyContainer,
StackedContentsCompatible {
    protected final Integer INVENTORY_SIZE;
    protected NonNullList<ItemStack> items;

    public AContainerTile(BlockEntityType<?> type, BlockPos pos, BlockState state, Integer inventorySize) {
        super(type, pos, state);
        this.INVENTORY_SIZE = inventorySize;
        this.items = inventorySize > 0 ? NonNullList.m_122780_((int)this.INVENTORY_SIZE, (Object)ItemStack.f_41583_) : NonNullList.m_122780_((int)0, (Object)ItemStack.f_41583_);
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        ContainerHelper.m_18973_((CompoundTag)compound, this.items);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)nbt, this.items);
        this.onLoadItemsComplete();
    }

    public void m_142339_(Level level) {
        super.m_142339_(level);
        this.onAddedToLevel();
    }

    public int m_6643_() {
        return this.INVENTORY_SIZE;
    }

    public boolean m_7983_() {
        return this.items.isEmpty();
    }

    public ItemStack m_8020_(int i) {
        return (ItemStack)this.items.get(i);
    }

    public ItemStack m_7407_(int i, int count) {
        return ContainerHelper.m_18969_(this.getItems(), (int)i, (int)count);
    }

    public ItemStack m_8016_(int i) {
        return ContainerHelper.m_18966_(this.getItems(), (int)i);
    }

    public void m_6836_(int i, ItemStack item) {
        this.items.set(i, (Object)item);
        if (item.m_41613_() > this.m_6893_()) {
            item.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    public boolean m_6542_(Player playerEntity) {
        if (this.f_58857_ != null && this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return !(playerEntity.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) > 64.0);
    }

    public void dropContent() {
        this.getItems().forEach(stack -> Containers.m_18992_((Level)this.f_58857_, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), (ItemStack)stack));
        this.m_6211_();
    }

    public void m_6211_() {
        this.getItems().clear();
    }

    public int[] m_7071_(Direction p_19238_) {
        int[] slots = new int[this.INVENTORY_SIZE.intValue()];
        for (int i = 0; i < this.INVENTORY_SIZE; ++i) {
            slots[i] = i;
        }
        return slots;
    }

    public boolean m_7157_(int slot, ItemStack stack, Direction side) {
        return true;
    }

    public boolean m_7155_(int p_19235_, ItemStack p_19236_, @Nullable Direction p_19237_) {
        return true;
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> items) {
        this.items = items;
    }

    public void m_5809_(StackedContents helper) {
        for (ItemStack itemstack : this.items) {
            helper.m_36491_(itemstack);
        }
    }

    protected void onLoadItemsComplete() {
    }

    protected void onAddedToLevel() {
    }
}

