/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.tofodroid.mods.mimi.common.recipe.ModRecipes;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class TuningTableRecipe
implements CraftingRecipe {
    public static final Serializer SERIALIZER = new Serializer();
    private final Ingredient instrument;
    private final Ingredient addition;
    private final ItemStack result;
    private final ResourceLocation recipeId;

    public TuningTableRecipe(ResourceLocation recipeId, Ingredient instrument, Ingredient addition, ItemStack result) {
        this.recipeId = recipeId;
        this.instrument = instrument;
        this.addition = addition;
        this.result = result;
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        return this.instrument.test(inv.m_8020_(0)) && this.addition.test(inv.m_8020_(1));
    }

    public ItemStack getIcon() {
        return new ItemStack((ItemLike)Blocks.f_50625_);
    }

    public ResourceLocation m_6423_() {
        return this.recipeId;
    }

    public String m_6076_() {
        return "";
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public RecipeType<?> m_6671_() {
        return ModRecipes.TUNING_TYPE;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        return NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList result = NonNullList.m_122779_();
        result.add(0, (Object)this.instrument);
        result.add(1, (Object)this.addition);
        return result;
    }

    public ItemStack assemble(CraftingContainer inv) {
        ItemStack itemstack = this.result.m_41777_();
        CompoundTag compoundnbt = inv.m_8020_(0).m_41783_();
        if (compoundnbt != null) {
            itemstack.m_41751_(compoundnbt.m_6426_());
        }
        return itemstack;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public ItemStack m_8043_() {
        return this.result;
    }

    public static class Serializer
    implements RecipeSerializer<TuningTableRecipe> {
        public static final String REGISTRY_NAME = "tuning";

        public TuningTableRecipe fromJson(ResourceLocation resource, JsonObject json) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)json.get("instrument"));
            Ingredient ingredient1 = Ingredient.m_43917_((JsonElement)json.get("addition"));
            ItemStack itemstack = ShapedRecipe.m_151274_((JsonObject)json.getAsJsonObject("result"));
            return new TuningTableRecipe(resource, ingredient, ingredient1, itemstack);
        }

        public TuningTableRecipe fromNetwork(ResourceLocation resource, FriendlyByteBuf buffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            Ingredient ingredient1 = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack itemstack = buffer.m_130267_();
            return new TuningTableRecipe(resource, ingredient, ingredient1, itemstack);
        }

        public void toNetwork(FriendlyByteBuf buffer, TuningTableRecipe recipe) {
            recipe.instrument.m_43923_(buffer);
            recipe.addition.m_43923_(buffer);
            buffer.m_130055_(recipe.result);
        }
    }
}

