/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.recipe;

import io.github.tofodroid.mods.mimi.common.item.IColorableItem;
import java.util.ArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.Level;

public class ColoredItemRecipe
extends CustomRecipe {
    public static final String REGISTRY_NAME = "coloreditem";
    public static final SimpleRecipeSerializer<?> SERIALIZER = new SimpleRecipeSerializer(ColoredItemRecipe::new);

    public ColoredItemRecipe(ResourceLocation recipeId) {
        super(recipeId);
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        ItemStack instrument = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stackI = inv.m_8020_(i);
            if (IColorableItem.isDyeableInstrument(stackI).booleanValue() && instrument.m_41619_()) {
                instrument = stackI;
                continue;
            }
            if (stackI.m_41619_() || stackI.m_41720_() instanceof DyeItem) continue;
            return false;
        }
        return !instrument.m_41619_();
    }

    public ItemStack assemble(CraftingContainer inv) {
        ItemStack instrument = ItemStack.f_41583_;
        ArrayList<DyeItem> dyes = new ArrayList<DyeItem>();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stackI = inv.m_8020_(i);
            if (stackI.m_41619_()) continue;
            if (IColorableItem.isDyeableInstrument(stackI).booleanValue() && instrument.m_41619_()) {
                instrument = stackI;
                continue;
            }
            if (!(stackI.m_41720_() instanceof DyeItem)) continue;
            dyes.add((DyeItem)stackI.m_41720_());
        }
        return !instrument.m_41619_() && !dyes.isEmpty() ? IColorableItem.dyeItem(instrument, dyes) : ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }
}

