/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.network;

import io.github.tofodroid.mods.mimi.common.MIMIMod;
import io.github.tofodroid.mods.mimi.common.network.CustomPacketPayload;
import io.netty.handler.codec.DecoderException;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class TransmitterControlPacket
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("mimi", TransmitterControlPacket.class.getSimpleName().toLowerCase());
    public final CONTROL control;
    public final Optional<Integer> controlData;
    public final Optional<UUID> songId;
    public final UUID transmitterId;

    public TransmitterControlPacket(UUID transmitterId, CONTROL control, Integer controlData, UUID songId) {
        this.transmitterId = transmitterId;
        this.control = control != null ? control : CONTROL.UNKNOWN;
        this.controlData = Optional.of(controlData);
        this.songId = Optional.of(songId);
    }

    public TransmitterControlPacket(UUID transmitterId, CONTROL control, Optional<Integer> controlData, Optional<UUID> songId) {
        this.transmitterId = transmitterId;
        this.control = control != null ? control : CONTROL.UNKNOWN;
        this.controlData = controlData;
        this.songId = songId;
    }

    public TransmitterControlPacket(UUID transmitterId, CONTROL control, Integer controlData) {
        this.transmitterId = transmitterId;
        this.control = control != null ? control : CONTROL.UNKNOWN;
        this.controlData = Optional.of(controlData);
        this.songId = Optional.empty();
    }

    public TransmitterControlPacket(UUID transmitterId, CONTROL control, UUID songId) {
        this.transmitterId = transmitterId;
        this.control = control != null ? control : CONTROL.UNKNOWN;
        this.controlData = Optional.empty();
        this.songId = Optional.of(songId);
    }

    public TransmitterControlPacket(UUID transmitterId, CONTROL control) {
        this.transmitterId = transmitterId;
        this.control = control != null ? control : CONTROL.UNKNOWN;
        this.controlData = Optional.empty();
        this.songId = Optional.empty();
    }

    @Override
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        TransmitterControlPacket.encodePacket(this, buf);
    }

    public static TransmitterControlPacket decodePacket(FriendlyByteBuf buf) {
        try {
            UUID transmitterId = buf.m_130259_();
            byte control = buf.readByte();
            Optional controlData = buf.m_236860_(FriendlyByteBuf::readInt);
            Optional songId = buf.m_236860_(FriendlyByteBuf::m_130259_);
            return new TransmitterControlPacket(transmitterId, CONTROL.fromByte(control), controlData, songId);
        }
        catch (IndexOutOfBoundsException e) {
            MIMIMod.LOGGER.error("TransmitterControlPacket did not contain enough bytes. Exception: " + String.valueOf(e));
            return null;
        }
        catch (DecoderException e) {
            MIMIMod.LOGGER.error("TransmitterControlPacket contained invalid bytes. Exception: " + String.valueOf((Object)e));
            return null;
        }
    }

    public static void encodePacket(TransmitterControlPacket pkt, FriendlyByteBuf buf) {
        buf.m_130077_(pkt.transmitterId);
        buf.writeByte((int)Integer.valueOf(pkt.control.ordinal()).byteValue());
        buf.m_236835_(pkt.controlData, FriendlyByteBuf::writeInt);
        buf.m_236835_(pkt.songId, FriendlyByteBuf::m_130077_);
    }

    public static enum CONTROL {
        PLAY,
        PAUSE,
        STOP,
        RESTART,
        SEEK,
        NEXT,
        PREV,
        LOOP_M,
        FAVE_M,
        SOURCE_M,
        MARKFAVE,
        SHUFFLE,
        UNKNOWN;


        public static CONTROL fromByte(byte b) {
            try {
                return CONTROL.values()[b];
            }
            catch (Exception exception) {
                return UNKNOWN;
            }
        }
    }
}

