/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.network;

import io.github.tofodroid.mods.mimi.common.MIMIMod;
import io.github.tofodroid.mods.mimi.common.network.CustomPacketPayload;
import io.github.tofodroid.mods.mimi.util.ByteUtils;
import io.netty.handler.codec.DecoderException;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class ServerMidiUploadPacket
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("mimi", ServerMidiUploadPacket.class.getSimpleName().toLowerCase());
    public static final int MAX_DATA_SIZE = 30000;
    public static final Byte UPLOAD_SUCCESS = ByteUtils.ZERO;
    public static final Byte UPLOAD_RESEND = Integer.valueOf(1).byteValue();
    public static final Byte UPLOAD_FAIL = Integer.valueOf(2).byteValue();
    private Boolean failed = false;
    public final UUID fileId;
    public final Byte part;
    public final Byte totalParts;
    public final byte[] data;

    public ServerMidiUploadPacket(UUID fileId, byte[] missingParts) {
        this(fileId, UPLOAD_RESEND, UPLOAD_RESEND, missingParts);
    }

    public ServerMidiUploadPacket(UUID fileId) {
        this(fileId, ByteUtils.ZERO, ByteUtils.ZERO, new byte[0]);
    }

    public ServerMidiUploadPacket(Byte totalParts, Byte part, byte[] data) {
        this(new UUID(0L, 0L), totalParts, part, data);
    }

    public ServerMidiUploadPacket markFailed() {
        this.failed = true;
        return this;
    }

    public Boolean failed() {
        return this.failed;
    }

    public ServerMidiUploadPacket(UUID fileId, Byte totalParts, Byte part, byte[] data) {
        this.fileId = fileId;
        this.part = part;
        this.totalParts = totalParts;
        if (data.length > 30000) {
            MIMIMod.LOGGER.error("ServerMidiUploadPacket data contained too many bytes!");
            this.data = new byte[0];
        } else {
            this.data = data;
        }
    }

    @Override
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        ServerMidiUploadPacket.encodePacket(this, buf);
    }

    public static ServerMidiUploadPacket decodePacket(FriendlyByteBuf buf) {
        try {
            Boolean failed = buf.readBoolean();
            UUID fileId = buf.m_130259_();
            if (!failed.booleanValue()) {
                Byte totalParts = buf.readByte();
                Byte part = buf.readByte();
                byte[] data = buf.m_130101_(30000);
                return new ServerMidiUploadPacket(fileId, totalParts, part, data);
            }
            return new ServerMidiUploadPacket(fileId).markFailed();
        }
        catch (IndexOutOfBoundsException e) {
            MIMIMod.LOGGER.error("ServerMidiUploadPacket did not contain enough bytes. Exception: " + String.valueOf(e));
            return null;
        }
        catch (DecoderException e) {
            MIMIMod.LOGGER.error("ServerMidiUploadPacket contained invalid bytes. Exception: " + String.valueOf((Object)e));
            return null;
        }
    }

    public static void encodePacket(ServerMidiUploadPacket pkt, FriendlyByteBuf buf) {
        buf.writeBoolean(pkt.failed.booleanValue());
        buf.m_130077_(pkt.fileId);
        if (!pkt.failed.booleanValue()) {
            buf.writeByte((int)pkt.totalParts.byteValue());
            buf.writeByte((int)pkt.part.byteValue());
            buf.m_130087_(pkt.data);
        }
    }
}

