/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.network;

import io.github.tofodroid.mods.mimi.common.MIMIMod;
import io.github.tofodroid.mods.mimi.common.api.event.AMidiEvent;
import io.github.tofodroid.mods.mimi.common.api.event.MidiEventType;
import io.github.tofodroid.mods.mimi.common.api.event.note.NoteEvent;
import io.github.tofodroid.mods.mimi.common.network.CustomPacketPayload;
import io.github.tofodroid.mods.mimi.util.ByteUtils;
import io.github.tofodroid.mods.mimi.util.NetworkUtils;
import io.github.tofodroid.mods.mimi.util.ResourceUtils;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.level.Level;

public class NoteEventPacket
implements CustomPacketPayload {
    public static final ResourceLocation ID = ResourceUtils.newModLocation(NoteEventPacket.class.getSimpleName().toLowerCase());
    @Nonnull
    public final MidiEventType type;
    @Nonnull
    public final Byte channel;
    @Nonnull
    public final Byte data1;
    @Nonnull
    public final Byte data2;
    @Nonnull
    public final Long noteServerTime;
    @Nonnull
    public final UUID player;
    @Nonnull
    public final BlockPos pos;
    @Nonnull
    public final Byte instrumentId;
    @Nullable
    public final InteractionHand instrumentHand;
    @Nullable
    public final Integer extData;

    @Override
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        NoteEventPacket.encodePacket(this, buf);
    }

    public static NoteEventPacket createControlPacket(Byte channel, Byte controller, Byte value, Byte instrumentId, UUID player, BlockPos pos, InteractionHand instrumentHand) {
        return new NoteEventPacket(MidiEventType.CONTROL, channel, controller, value, instrumentId, player, pos, MIMIMod.getProxy().getCurrentServerMillis(), instrumentHand, null);
    }

    public static NoteEventPacket createControlPacket(Byte channel, Byte controller, Byte value, Byte instrumentId, UUID player, BlockPos pos, Long noteServerTime, InteractionHand instrumentHand) {
        return new NoteEventPacket(MidiEventType.CONTROL, channel, controller, value, instrumentId, player, pos, noteServerTime, instrumentHand, null);
    }

    public static NoteEventPacket createResetPacket(Byte instrumentId, UUID player, BlockPos pos, InteractionHand instrumentHand) {
        return new NoteEventPacket(MidiEventType.RESET, AMidiEvent.ALL_CHANNELS, ByteUtils.ZERO, ByteUtils.ZERO, instrumentId, player, pos, MIMIMod.getProxy().getCurrentServerMillis(), instrumentHand, null);
    }

    public static NoteEventPacket createResetPacket(Byte instrumentId, UUID player, BlockPos pos, Long noteServerTime, InteractionHand instrumentHand) {
        return new NoteEventPacket(MidiEventType.RESET, AMidiEvent.ALL_CHANNELS, ByteUtils.ZERO, ByteUtils.ZERO, instrumentId, player, pos, noteServerTime, instrumentHand, null);
    }

    public static NoteEventPacket createNotePacket(Byte channel, Byte note, Byte velocity, Byte instrumentId, UUID player, BlockPos pos, Long noteServerTime, InteractionHand instrumentHand) {
        return new NoteEventPacket(velocity == 0 ? MidiEventType.NOTE_OFF : MidiEventType.NOTE_ON, channel, note, velocity, instrumentId, player, pos, noteServerTime, instrumentHand, null);
    }

    public static NoteEventPacket createNotePacket(Byte channel, Byte note, Byte velocity, Byte instrumentId, UUID player, BlockPos pos, InteractionHand instrumentHand) {
        return new NoteEventPacket(velocity == 0 ? MidiEventType.NOTE_OFF : MidiEventType.NOTE_ON, channel, note, velocity, instrumentId, player, pos, MIMIMod.getProxy().getCurrentServerMillis(), instrumentHand, null);
    }

    public static NoteEventPacket fromNoteEvent(NoteEvent event) {
        return new NoteEventPacket(event.type, event.channel, event.note, event.velocity, event.instrumentId, event.senderId, event.pos, event.eventTime, event.handIn, null);
    }

    public NoteEvent toNoteEvent(Boolean clientSource, UUID senderId, ServerLevel sourceLevel) {
        NoteEvent event = new NoteEvent(this.type, clientSource, this.instrumentId, this.instrumentHand, this.channel, this.data1, this.data2, senderId, (ResourceKey<Level>)sourceLevel.m_46472_(), this.pos, this.noteServerTime);
        return this.extData != null ? (NoteEvent)event.withExtData(this.extData) : event;
    }

    protected NoteEventPacket(MidiEventType type, Byte channel, Byte data1, Byte data2, Byte instrumentId, UUID player, BlockPos pos, Long noteServerTime, InteractionHand instrumentHand, Integer extData) {
        this.type = type;
        this.channel = channel;
        this.data1 = data1;
        this.data2 = data2;
        this.instrumentId = instrumentId;
        this.player = player;
        this.pos = pos;
        this.noteServerTime = noteServerTime;
        this.instrumentHand = instrumentHand;
        this.extData = extData;
    }

    public static NoteEventPacket decodePacket(FriendlyByteBuf buf) {
        try {
            MidiEventType type = MidiEventType.fromByte(buf.readByte());
            byte channel = buf.readByte();
            byte data1 = ByteUtils.ZERO;
            byte data2 = ByteUtils.ZERO;
            if (type != MidiEventType.RESET) {
                data1 = buf.readByte();
            }
            if (type != MidiEventType.RESET || type != MidiEventType.NOTE_OFF) {
                data2 = buf.readByte();
            }
            byte instrumentId = buf.readByte();
            UUID player = buf.m_130259_();
            BlockPos pos = buf.m_130135_();
            Long noteServerTime = buf.readLong();
            InteractionHand instrumentHand = NetworkUtils.decodeHand(buf.readByte());
            Integer extData = null;
            if (buf.readBoolean()) {
                extData = buf.readInt();
            }
            return new NoteEventPacket(type, channel, data1, data2, instrumentId, player, pos, noteServerTime, instrumentHand, extData);
        }
        catch (IndexOutOfBoundsException e) {
            MIMIMod.LOGGER.error("MidiNoteOnPacket did not contain enough bytes. Exception: " + String.valueOf(e));
            return null;
        }
    }

    public static void encodePacket(NoteEventPacket pkt, FriendlyByteBuf buf) {
        buf.writeByte((int)pkt.type.toByte().byteValue());
        buf.writeByte((int)pkt.channel.byteValue());
        if (pkt.type != MidiEventType.RESET) {
            buf.writeByte((int)pkt.data1.byteValue());
        }
        if (pkt.type != MidiEventType.RESET || pkt.type != MidiEventType.NOTE_OFF) {
            buf.writeByte((int)pkt.data2.byteValue());
        }
        buf.writeByte((int)pkt.instrumentId.byteValue());
        buf.m_130077_(pkt.player);
        buf.m_130064_(pkt.pos);
        buf.writeLong(pkt.noteServerTime.longValue());
        buf.writeByte((int)NetworkUtils.encodeHand(pkt.instrumentHand).byteValue());
        buf.writeBoolean(pkt.extData != null);
        if (pkt.extData != null) {
            buf.writeInt(pkt.extData.intValue());
        }
    }
}

