/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.network;

import io.github.tofodroid.mods.mimi.common.MIMIMod;
import io.github.tofodroid.mods.mimi.common.network.CustomPacketPayload;
import io.github.tofodroid.mods.mimi.util.MidiNbtDataUtils;
import io.github.tofodroid.mods.mimi.util.NetworkUtils;
import io.netty.handler.codec.DecoderException;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public class ConfigurableMidiTileSyncPacket
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("mimi", ConfigurableMidiTileSyncPacket.class.getSimpleName().toLowerCase());
    public final BlockPos tilePos;
    public final InteractionHand handIn;
    public final UUID midiSource;
    public final String midiSourceName;
    public final Byte filterOct;
    public final Byte filterNote;
    public final Boolean invertNoteOct;
    public final Byte instrumentId;
    public final Integer enabledChannelsInt;
    public final Boolean invertSignal;
    public final Boolean analogMode;
    public final Boolean triggerNoteStart;
    public final Byte holdTicks;
    public final Byte broadcastRange;
    public final Byte[] channelMap;

    private ConfigurableMidiTileSyncPacket(BlockPos tilePos, InteractionHand handIn, UUID midiSource, String midiSourceName, Byte filterOct, Byte filterNote, Boolean invertNoteOct, Integer enabledChannelsInt, Byte instrumentId, Boolean invertSignal, Boolean analogMode, Boolean triggerNoteStart, Byte holdTicks, Byte broadcastRange, Byte[] channelMap) {
        this.handIn = handIn;
        this.tilePos = tilePos;
        this.midiSource = midiSource;
        this.midiSourceName = midiSourceName;
        this.filterOct = filterOct;
        this.filterNote = filterNote;
        this.invertNoteOct = invertNoteOct;
        this.enabledChannelsInt = enabledChannelsInt;
        this.instrumentId = instrumentId;
        this.invertSignal = invertSignal;
        this.analogMode = analogMode;
        this.triggerNoteStart = triggerNoteStart;
        this.holdTicks = holdTicks;
        this.broadcastRange = broadcastRange;
        this.channelMap = channelMap;
    }

    public ConfigurableMidiTileSyncPacket(ItemStack sourceStack, BlockPos tilePos, InteractionHand handIn) {
        this.handIn = handIn;
        this.tilePos = tilePos;
        this.midiSource = MidiNbtDataUtils.getMidiSource(sourceStack);
        this.midiSourceName = MidiNbtDataUtils.getMidiSourceName(sourceStack, false);
        this.filterOct = MidiNbtDataUtils.getFilterOct(sourceStack);
        this.filterNote = MidiNbtDataUtils.getFilterNote(sourceStack);
        this.invertNoteOct = MidiNbtDataUtils.getInvertNoteOct(sourceStack);
        this.enabledChannelsInt = MidiNbtDataUtils.getEnabledChannelsInt(sourceStack);
        this.instrumentId = MidiNbtDataUtils.getFilterInstrument(sourceStack);
        this.invertSignal = MidiNbtDataUtils.getInvertSignal(sourceStack);
        this.analogMode = MidiNbtDataUtils.getAnalogMode(sourceStack);
        this.triggerNoteStart = MidiNbtDataUtils.getTriggerNoteStart(sourceStack);
        this.holdTicks = MidiNbtDataUtils.getHoldTicks(sourceStack);
        this.broadcastRange = MidiNbtDataUtils.getBroadcastRange(sourceStack);
        this.channelMap = MidiNbtDataUtils.getChannelMap(sourceStack);
    }

    @Override
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        ConfigurableMidiTileSyncPacket.encodePacket(this, buf);
    }

    public static ConfigurableMidiTileSyncPacket decodePacket(FriendlyByteBuf buf) {
        try {
            Boolean isHand = buf.readBoolean();
            InteractionHand handIn = null;
            BlockPos tilePos = null;
            if (isHand.booleanValue()) {
                handIn = NetworkUtils.decodeHand(buf.readByte());
            } else {
                tilePos = buf.m_130135_();
            }
            UUID midiSource = null;
            if (buf.readBoolean()) {
                midiSource = buf.m_130259_();
            }
            String midiSourceName = null;
            if (buf.readBoolean()) {
                midiSourceName = buf.m_130136_(64);
            }
            Byte filterOct = buf.readByte();
            Byte filterNote = buf.readByte();
            Boolean invertNoteOct = buf.readBoolean();
            Integer enabledChannelsInt = buf.readInt();
            Byte instrumentId = buf.readByte();
            Boolean invertSignal = buf.readBoolean();
            Boolean analogMode = buf.readBoolean();
            Boolean triggerNoteStart = buf.readBoolean();
            Byte holdTicks = buf.readByte();
            Byte broadcastRange = buf.readByte();
            Byte[] channelMap = new Byte[16];
            for (int i = 0; i < 16; ++i) {
                channelMap[i] = buf.readByte();
            }
            return new ConfigurableMidiTileSyncPacket(tilePos, handIn, midiSource, midiSourceName, filterOct, filterNote, invertNoteOct, enabledChannelsInt, instrumentId, invertSignal, analogMode, triggerNoteStart, holdTicks, broadcastRange, channelMap);
        }
        catch (IndexOutOfBoundsException e) {
            MIMIMod.LOGGER.error("ConfigurableMidiTileSyncPacket did not contain enough bytes. Exception: " + String.valueOf(e));
            return null;
        }
        catch (DecoderException e) {
            MIMIMod.LOGGER.error("ConfigurableMidiTileSyncPacket contained invalid bytes. Exception: " + String.valueOf((Object)e));
            return null;
        }
    }

    public static void encodePacket(ConfigurableMidiTileSyncPacket pkt, FriendlyByteBuf buf) {
        if (pkt.handIn != null) {
            buf.writeBoolean(true);
            buf.writeByte((int)NetworkUtils.encodeHand(pkt.handIn).byteValue());
        } else {
            buf.writeBoolean(false);
            buf.m_130064_(pkt.tilePos);
        }
        if (pkt.midiSource != null) {
            buf.writeBoolean(true);
            buf.m_130077_(pkt.midiSource);
        } else {
            buf.writeBoolean(false);
        }
        if (pkt.midiSourceName != null) {
            buf.writeBoolean(true);
            buf.m_130072_(pkt.midiSourceName, 64);
        } else {
            buf.writeBoolean(false);
        }
        buf.writeByte((int)pkt.filterOct.byteValue());
        buf.writeByte((int)pkt.filterNote.byteValue());
        buf.writeBoolean(pkt.invertNoteOct.booleanValue());
        buf.writeInt(pkt.enabledChannelsInt.intValue());
        buf.writeByte((int)pkt.instrumentId.byteValue());
        buf.writeBoolean(pkt.invertSignal.booleanValue());
        buf.writeBoolean(pkt.analogMode.booleanValue());
        buf.writeBoolean(pkt.triggerNoteStart.booleanValue());
        buf.writeByte((int)pkt.holdTicks.byteValue());
        buf.writeByte((int)pkt.broadcastRange.byteValue());
        for (int i = 0; i < 16; ++i) {
            buf.writeByte((int)pkt.channelMap[i].byteValue());
        }
    }
}

