/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.container;

import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;

public abstract class APlayerInventoryContainer
extends AbstractContainerMenu {
    public static final int PLAYER_INVENTORY_MIN_SLOT_ID = 0;
    public static final int PLAYER_HOTBAR_MIN_SLOT_ID = 27;
    public static final int TARGET_CONTAINER_MIN_SLOT_ID = 36;
    protected static final int SLOT_SPACING = 18;
    protected static final int INVENTORY_PLAYER_ROW_COUNT = 3;
    protected static final int INVENTORY_PLAYER_COLUMN_COUNT = 9;
    protected static final int HOTBAR_SLOT_COUNT = 9;
    protected static final int HOTBAR_Y_OFFSET = 40;
    protected Inventory playerInventory;

    public APlayerInventoryContainer(MenuType<?> menuType, int id, Inventory playerInventory) {
        super(menuType, id);
        this.playerInventory = playerInventory;
        this.buildPlayerSlots(playerInventory);
    }

    protected abstract Integer getPlayerInventoryX();

    protected abstract Integer getPlayerInventoryY();

    protected void buildPlayerSlots(Inventory playerInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int slot = 9 + row * 9 + col;
                int xPos = this.getPlayerInventoryX() + col * 18;
                int yPos = this.getPlayerInventoryY() + (row - 1) * 18;
                this.m_38897_(this.buildPlayerSlot(playerInventory, slot, xPos, yPos));
            }
        }
        for (int slot = 0; slot < 9; ++slot) {
            int xPos = this.getPlayerInventoryX() + slot * 18;
            this.m_38897_(this.buildHotbarSlot(playerInventory, slot, xPos, this.getPlayerInventoryY() + 40));
        }
    }

    protected Slot buildHotbarSlot(Inventory playerInventory, int slot, int xPos, int yPos) {
        return this.buildPlayerSlot(playerInventory, slot, xPos, yPos);
    }

    protected Slot buildPlayerSlot(Inventory playerInventory, int slot, int xPos, int yPos) {
        return new Slot((Container)playerInventory, slot, xPos, yPos);
    }

    public boolean m_6875_(Player p_38874_) {
        return p_38874_.m_6084_();
    }
}

