/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.block;

import io.github.tofodroid.mods.mimi.common.block.AColoredBlock;
import io.github.tofodroid.mods.mimi.util.TagUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class BlockLedCube
extends AColoredBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final BooleanProperty INVERTED = BlockStateProperties.f_61441_;
    public static final String REGISTRY_NAME_A = "ledcube_a";
    public static final String REGISTRY_NAME_B = "ledcube_b";
    public static final String REGISTRY_NAME_C = "ledcube_c";
    public static final String REGISTRY_NAME_D = "ledcube_d";
    public static final String REGISTRY_NAME_E = "ledcube_e";
    public static final String REGISTRY_NAME_F = "ledcube_f";
    public static final String REGISTRY_NAME_G = "ledcube_g";
    public static final String REGISTRY_NAME_H = "ledcube_h";

    public BlockLedCube(BlockBehaviour.Properties props) {
        super(props.m_155956_(6.0f).m_60978_(2.0f).m_60918_(SoundType.f_56762_).m_60982_((a, b, c) -> true).m_60991_((a, b, c) -> BlockLedCube.isLit(a)));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)INVERTED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DYE_ID, (Comparable)Integer.valueOf(0)));
    }

    public static Boolean isLit(BlockState state) {
        return state.m_61143_((Property)INVERTED) != state.m_61143_((Property)POWERED);
    }

    public float m_7749_(BlockState state, BlockGetter p_153690_, BlockPos p_153691_) {
        return (Boolean)state.m_61143_((Property)POWERED) != false ? 1.0f : super.m_7749_(state, p_153690_, p_153691_);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (Items.f_41978_.equals(player.m_21120_(handIn).m_41720_()) || Items.f_42153_.equals(player.m_21120_(handIn).m_41720_())) {
            if (!worldIn.f_46443_) {
                worldIn.m_7731_(pos, (BlockState)state.m_61122_((Property)INVERTED), 2);
                worldIn.m_5594_(null, pos, SoundEvents.f_12027_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        if (player.m_21120_(handIn).m_41619_()) {
            if (!worldIn.f_46443_) {
                Integer dyeId = (Integer)state.m_61143_((Property)DYE_ID);
                worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)DYE_ID, (Comparable)Integer.valueOf(dyeId < 15 ? dyeId + 1 : 0)), 2);
                worldIn.m_5594_(null, pos, SoundEvents.f_12210_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public int m_7753_(BlockState state, BlockGetter p_60586_, BlockPos p_60587_) {
        return BlockLedCube.isLit(state) != false ? 15 : super.m_7753_(state, p_60586_, p_60587_);
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)super.m_5573_(context).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(context.m_43725_().m_46753_(context.m_8083_())))).m_61124_((Property)INVERTED, (Comparable)TagUtils.getBooleanOrDefault(context.m_43722_(), INVERTED.m_61708_(), false));
    }

    @Override
    protected void appendSettingsTooltip(ItemStack blockItemStack, List<Component> tooltip) {
        super.appendSettingsTooltip(blockItemStack, tooltip);
        tooltip.add((Component)Component.m_237113_((String)"Inverted:").m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD}));
        tooltip.add((Component)Component.m_237113_((String)("  " + (TagUtils.getBooleanOrDefault(blockItemStack, INVERTED.m_61708_(), false) != false ? "Yes" : "No"))).m_130944_(new ChatFormatting[]{ChatFormatting.LIGHT_PURPLE, ChatFormatting.ITALIC}));
    }

    @Override
    public ItemStack m_7397_(BlockGetter reader, BlockPos pos, BlockState state) {
        ItemStack itemstack = super.m_7397_(reader, pos, state);
        itemstack.m_41784_().m_128379_(INVERTED.m_61708_(), state.m_61145_((Property)INVERTED).orElse(false).booleanValue());
        return itemstack;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> state) {
        state.m_61104_(new Property[]{POWERED});
        state.m_61104_(new Property[]{INVERTED});
        state.m_61104_(new Property[]{DYE_ID});
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue() && !worldIn.m_46753_(pos)) {
            worldIn.m_7731_(pos, (BlockState)state.m_61122_((Property)POWERED), 2);
        }
    }

    public boolean m_7899_(BlockState p_60571_) {
        return false;
    }

    public int m_6378_(BlockState p_60483_, BlockGetter p_60484_, BlockPos p_60485_, Direction p_60486_) {
        return 0;
    }

    public boolean m_7278_(BlockState p_60457_) {
        return false;
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        Boolean wasPowered;
        if (!worldIn.f_46443_ && (wasPowered = (Boolean)state.m_61143_((Property)POWERED)).booleanValue() != worldIn.m_46753_(pos)) {
            if (wasPowered.booleanValue()) {
                worldIn.m_186460_(pos, (Block)this, 1);
            } else {
                worldIn.m_7731_(pos, (BlockState)state.m_61122_((Property)POWERED), 2);
            }
        }
    }
}

