/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.block;

import io.github.tofodroid.mods.mimi.common.block.AContainerBlock;
import io.github.tofodroid.mods.mimi.common.tile.AConfigurableTile;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;

public abstract class AConfigurableTileBlock<B extends AConfigurableTile>
extends AContainerBlock<B> {
    public AConfigurableTileBlock(BlockBehaviour.Properties builder) {
        super(builder);
    }

    public abstract OpenGuiWrapper openGuiWrapper();

    protected abstract void appendSettingsTooltip(ItemStack var1, List<Component> var2);

    protected Boolean shouldSkipUse(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand) {
        return false;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (this.shouldSkipUse(state, worldIn, pos, player, hand).booleanValue()) {
            return worldIn.f_46443_ ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        AConfigurableTile tile = (AConfigurableTile)((Object)this.getTileForBlock(worldIn, pos));
        if (tile != null && worldIn.f_46443_) {
            this.openGuiWrapper().accept(worldIn, player, tile.m_58899_(), null, tile.getSourceStack());
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter blockGetter, List<Component> tooltip, TooltipFlag flag) {
        super.m_5871_(stack, blockGetter, tooltip, flag);
        this.appendSettingsTooltip(stack, tooltip);
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        AConfigurableTile tileEntity = (AConfigurableTile)((Object)this.getTileForBlock(worldIn, pos));
        if (tileEntity instanceof AConfigurableTile) {
            ItemStack newStack = new ItemStack((ItemLike)stack.m_41720_(), 1);
            newStack.m_41751_(stack.m_41784_().m_6426_());
            tileEntity.setSourceStack(newStack);
        }
    }

    public ItemStack m_7397_(BlockGetter getter, BlockPos pos, BlockState state) {
        BlockEntity tile = getter.m_7702_(pos);
        if (tile != null && tile instanceof AConfigurableTile) {
            return ((AConfigurableTile)tile).getSourceStack();
        }
        return super.m_7397_(getter, pos, state);
    }

    public List<ItemStack> m_7381_(BlockState p_60537_, LootContext.Builder p_60538_) {
        return Arrays.asList(new ItemStack[0]);
    }

    public ItemStack getSourceStack(Level worldIn, BlockPos pos) {
        AConfigurableTile tile = (AConfigurableTile)((Object)this.getTileForBlock(worldIn, pos));
        if (tile != null) {
            return tile.getSourceStack();
        }
        return null;
    }

    public void setSourceStack(Level worldIn, BlockPos pos, ItemStack stack) {
        AConfigurableTile tile = (AConfigurableTile)((Object)this.getTileForBlock(worldIn, pos));
        if (tile != null) {
            tile.setSourceStack(stack);
        }
    }

    @FunctionalInterface
    public static interface OpenGuiWrapper {
        public void accept(Level var1, Player var2, BlockPos var3, InteractionHand var4, ItemStack var5);
    }
}

