/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.block;

import io.github.tofodroid.mods.mimi.util.TagUtils;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class AColoredBlock
extends Block {
    public static final IntegerProperty DYE_ID = IntegerProperty.m_61631_((String)"dye_id", (int)0, (int)15);

    public AColoredBlock(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Integer dyeId = TagUtils.getIntOrDefault(context.m_43722_(), DYE_ID.m_61708_(), 0);
        if (dyeId < 0 || dyeId > 15) {
            dyeId = 0;
        }
        return (BlockState)this.m_49966_().m_61124_((Property)DYE_ID, (Comparable)dyeId);
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.f_46443_) {
            ItemStack itemstack = this.m_7397_((BlockGetter)level, pos, state);
            level.m_7967_((Entity)this.getItemEntity(level, pos, itemstack));
        }
        super.m_5707_(level, pos, state, player);
    }

    protected ItemEntity getItemEntity(Level level, BlockPos pos, ItemStack itemstack) {
        ItemEntity itementity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, itemstack);
        itementity.m_32060_();
        return itementity;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter blockGetter, List<Component> tooltip, TooltipFlag flag) {
        super.m_5871_(stack, blockGetter, tooltip, flag);
        this.appendSettingsTooltip(stack, tooltip);
    }

    public ItemStack m_7397_(BlockGetter getter, BlockPos pos, BlockState state) {
        ItemStack itemstack = super.m_7397_(getter, pos, state);
        itemstack.m_41784_().m_128405_(DYE_ID.m_61708_(), state.m_61145_((Property)DYE_ID).orElse(0).intValue());
        return itemstack;
    }

    protected void appendSettingsTooltip(ItemStack blockItemStack, List<Component> tooltip) {
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237113_((String)"Dyed:").m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD}));
        tooltip.add((Component)Component.m_237113_((String)("  " + DyeColor.m_41053_((int)TagUtils.getIntOrDefault(blockItemStack, DYE_ID.m_61708_(), 0)).name())).m_130944_(new ChatFormatting[]{ChatFormatting.LIGHT_PURPLE, ChatFormatting.ITALIC}));
    }

    public static final Integer getDecimalColorFromState(BlockState state) {
        Optional dyeId = state.m_61145_((Property)DYE_ID);
        if (dyeId.isPresent()) {
            return DyeColor.m_41053_((int)((Integer)dyeId.get())).m_41070_();
        }
        return DyeColor.WHITE.m_41070_();
    }
}

