/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.client.network;

import io.github.tofodroid.com.sun.media.sound.MidiUtils;
import io.github.tofodroid.mods.mimi.common.MIMIMod;
import io.github.tofodroid.mods.mimi.common.midi.LocalMidiInfo;
import io.github.tofodroid.mods.mimi.common.network.NetworkProxy;
import io.github.tofodroid.mods.mimi.common.network.ServerMidiUploadPacket;
import io.github.tofodroid.mods.mimi.util.ByteUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class ClientMidiUploadManager {
    public static final Integer MAX_TOTAL_SEQUENCE_SIZE = 6000000;

    public static List<ServerMidiUploadPacket> generateUploadPackets(LocalMidiInfo file) {
        if (file.file.exists()) {
            try {
                byte[] bytes = MidiUtils.sequenceToByteArray(file.loadSequenceFromFile());
                ArrayList<byte[]> dataParts = new ArrayList<byte[]>();
                if (bytes.length > MAX_TOTAL_SEQUENCE_SIZE) {
                    throw new IOException("Sequence is too large to upload. Size: " + bytes.length + " / " + MAX_TOTAL_SEQUENCE_SIZE);
                }
                if (bytes.length > 30000) {
                    for (int i = 0; i < bytes.length; i += 30000) {
                        Integer rangeEnd = Math.min(i + 30000, bytes.length);
                        dataParts.add(Arrays.copyOfRange(bytes, i, (int)rangeEnd));
                    }
                } else {
                    dataParts.add(bytes);
                }
                ArrayList<ServerMidiUploadPacket> packets = new ArrayList<ServerMidiUploadPacket>();
                Integer i = 0;
                while (i < dataParts.size()) {
                    packets.add(new ServerMidiUploadPacket(file.fileId, Integer.valueOf(dataParts.size()).byteValue(), i.byteValue(), (byte[])dataParts.get(i)));
                    Integer n = i;
                    i = i + 1;
                }
                return packets;
            }
            catch (Exception e) {
                MIMIMod.LOGGER.error("Failed to upload MIDI Sequence: ", (Throwable)e);
            }
        }
        return Arrays.asList(new ServerMidiUploadPacket(file.fileId).markFailed());
    }

    public static void uploadFileToServer(LocalMidiInfo file) {
        for (ServerMidiUploadPacket packet : ClientMidiUploadManager.generateUploadPackets(file)) {
            ClientMidiUploadManager.sendServerBoundPacket(packet);
        }
    }

    public static void uploadFilePartsToServer(LocalMidiInfo file, byte[] parts) {
        List<ServerMidiUploadPacket> packets = ClientMidiUploadManager.generateUploadPackets(file);
        for (byte part : parts) {
            ClientMidiUploadManager.sendServerBoundPacket(packets.get(part));
        }
    }

    public static void sendServerBoundPacket(ServerMidiUploadPacket packet) {
        NetworkProxy.sendToServer(packet);
    }

    public static void handlePacket(ServerMidiUploadPacket message) {
        if (message.fileId != null) {
            LocalMidiInfo fileInfo = MIMIMod.getProxy().clientMidiFiles().getInfoById(message.fileId);
            if (fileInfo != null) {
                if (message.data.length > 0) {
                    ClientMidiUploadManager.uploadFilePartsToServer(fileInfo, message.data);
                } else {
                    ClientMidiUploadManager.uploadFileToServer(fileInfo);
                }
            } else {
                NetworkProxy.sendToServer(new ServerMidiUploadPacket(message.fileId, ByteUtils.ZERO, ByteUtils.ZERO, new byte[0]));
            }
        }
    }
}

