/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.client.gui.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.tofodroid.mods.mimi.client.gui.CommonGuiUtils;
import io.github.tofodroid.mods.mimi.client.gui.widget.BaseWidget;
import io.github.tofodroid.mods.mimi.util.MidiNbtDataUtils;
import io.github.tofodroid.mods.mimi.util.Vector2Int;
import net.minecraft.client.gui.Font;
import net.minecraft.world.item.ItemStack;

public class TriggerModeWidget
extends BaseWidget {
    private static final Vector2Int DOWN_BUTTON_COORDS = new Vector2Int(77, 3);
    private static final Vector2Int UP_BUTTON_COORDS = new Vector2Int(155, 3);
    private static final Vector2Int VALUE_TEXT_COORDS = new Vector2Int(97, 7);
    private ItemStack midiStack;

    public TriggerModeWidget(ItemStack midiStack, Vector2Int screenOffset, Vector2Int start) {
        super("textures/gui/widget/trigger_mode.png", 173, new Vector2Int(173, 21), screenOffset, start);
        this.midiStack = midiStack;
    }

    @Override
    public void renderGraphics(PoseStack graphics, Integer mouseX, Integer mouseY) {
        super.renderGraphics(graphics, mouseX, mouseY);
    }

    @Override
    public void renderText(PoseStack graphics, Font font, Integer mouseX, Integer mouseY) {
        super.renderText(graphics, font, mouseX, mouseY);
        this.drawStringAbsolute(graphics, font, MidiNbtDataUtils.getTriggerNoteStart(this.midiStack) != false ? "Note Start" : "Note Held", this.ABSOLUTE_START.x() + TriggerModeWidget.VALUE_TEXT_COORDS.x, this.ABSOLUTE_START.y() + TriggerModeWidget.VALUE_TEXT_COORDS.y, -16718336);
    }

    @Override
    protected Boolean mouseClicked(Vector2Int localMouseCoords, Integer mouseButton) {
        if (CommonGuiUtils.clickedBox(localMouseCoords.x(), localMouseCoords.y(), DOWN_BUTTON_COORDS).booleanValue()) {
            MidiNbtDataUtils.setTriggerNoteStart(this.midiStack, MidiNbtDataUtils.getTriggerNoteStart(this.midiStack) == false);
            return true;
        }
        if (CommonGuiUtils.clickedBox(localMouseCoords.x(), localMouseCoords.y(), UP_BUTTON_COORDS).booleanValue()) {
            MidiNbtDataUtils.setTriggerNoteStart(this.midiStack, MidiNbtDataUtils.getTriggerNoteStart(this.midiStack) == false);
            return true;
        }
        return false;
    }
}

