/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.client.gui.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.tofodroid.mods.mimi.client.gui.CommonGuiUtils;
import io.github.tofodroid.mods.mimi.client.gui.widget.BaseWidget;
import io.github.tofodroid.mods.mimi.util.MidiNbtDataUtils;
import io.github.tofodroid.mods.mimi.util.Vector2Int;
import net.minecraft.client.gui.Font;
import net.minecraft.world.item.ItemStack;

public class NoteFilterWidget
extends BaseWidget {
    protected static final Vector2Int FILTER_NOTE_LETTER_BUTTON_COORDS = new Vector2Int(3, 14);
    protected static final Vector2Int FILTER_NOTE_OCTAVE_BUTTON_COORDS = new Vector2Int(22, 14);
    protected static final Vector2Int FILTER_NOTE_INVERT_BUTTON_COORDS = new Vector2Int(98, 14);
    private ItemStack midiStack;
    private Integer filterNoteOctave;
    private Integer filterNoteLetter;

    public NoteFilterWidget(ItemStack midiStack, Vector2Int screenOffset, Vector2Int start) {
        super("textures/gui/widget/note_filter.png", 116, new Vector2Int(116, 32), screenOffset, start);
        this.midiStack = midiStack;
        this.filterNoteLetter = MidiNbtDataUtils.getFilterNote(midiStack).intValue();
        this.filterNoteOctave = MidiNbtDataUtils.getFilterOct(midiStack).intValue();
    }

    @Override
    public void renderGraphics(PoseStack graphics, Integer mouseX, Integer mouseY) {
        super.renderGraphics(graphics, mouseX, mouseY);
        if (MidiNbtDataUtils.getInvertNoteOct(this.midiStack).booleanValue()) {
            this.blitAbsolute(graphics, this.GUI_TEXTURE, this.ABSOLUTE_START.x() + 104, this.ABSOLUTE_START.y() + 8, 0.0f, 32.0f, 3, 3, this.TEXTURE_SIZE, this.TEXTURE_SIZE);
        }
    }

    @Override
    public void renderText(PoseStack graphics, Font font, Integer mouseX, Integer mouseY) {
        this.drawStringAbsolute(graphics, font, MidiNbtDataUtils.getFilteredNotesAsString(this.midiStack), this.ABSOLUTE_START.x() + 43, this.ABSOLUTE_START.y() + 18, -16718336);
    }

    @Override
    protected Boolean mouseClicked(Vector2Int localMouseCoords, Integer mouseButton) {
        if (CommonGuiUtils.clickedBox(localMouseCoords.x(), localMouseCoords.y(), FILTER_NOTE_OCTAVE_BUTTON_COORDS).booleanValue()) {
            this.shiftFilterNoteOctave();
            return true;
        }
        if (CommonGuiUtils.clickedBox(localMouseCoords.x(), localMouseCoords.y(), FILTER_NOTE_LETTER_BUTTON_COORDS).booleanValue()) {
            this.shiftFilterNoteLetter();
            return true;
        }
        if (CommonGuiUtils.clickedBox(localMouseCoords.x(), localMouseCoords.y(), FILTER_NOTE_INVERT_BUTTON_COORDS).booleanValue()) {
            MidiNbtDataUtils.setInvertNoteOct(this.midiStack, MidiNbtDataUtils.getInvertNoteOct(this.midiStack) == false);
            return true;
        }
        return false;
    }

    protected void shiftFilterNoteLetter() {
        if (this.filterNoteLetter < 11) {
            Integer n = this.filterNoteLetter;
            this.filterNoteLetter = this.filterNoteLetter + 1;
            if (this.invalidFilterNote().booleanValue()) {
                this.filterNoteLetter = -1;
            }
        } else {
            this.filterNoteLetter = -1;
        }
        MidiNbtDataUtils.setFilterNote(this.midiStack, this.filterNoteLetter.byteValue());
    }

    protected void shiftFilterNoteOctave() {
        if (this.filterNoteOctave < 10) {
            Integer n = this.filterNoteOctave;
            this.filterNoteOctave = this.filterNoteOctave + 1;
            if (this.invalidFilterNote().booleanValue()) {
                this.filterNoteOctave = -1;
            }
        } else {
            this.filterNoteOctave = -1;
        }
        MidiNbtDataUtils.setFilterOct(this.midiStack, this.filterNoteOctave.byteValue());
    }

    protected Boolean invalidFilterNote() {
        return Integer.valueOf(this.filterNoteOctave * 12 + this.filterNoteLetter) > 127;
    }
}

