/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.tofodroid.mods.mimi.client.gui.BaseGui;
import io.github.tofodroid.mods.mimi.client.gui.widget.AnalogModeWidget;
import io.github.tofodroid.mods.mimi.client.gui.widget.HoldTicksWidget;
import io.github.tofodroid.mods.mimi.client.gui.widget.InvertSignalWidget;
import io.github.tofodroid.mods.mimi.client.gui.widget.MidiChannelToggleWidget;
import io.github.tofodroid.mods.mimi.client.gui.widget.NoteFilterWidget;
import io.github.tofodroid.mods.mimi.client.gui.widget.TransmitterSourceWidget;
import io.github.tofodroid.mods.mimi.client.gui.widget.TriggerModeWidget;
import io.github.tofodroid.mods.mimi.common.MIMIMod;
import io.github.tofodroid.mods.mimi.common.network.ConfigurableMidiTileSyncPacket;
import io.github.tofodroid.mods.mimi.common.network.NetworkProxy;
import io.github.tofodroid.mods.mimi.util.Vector2Int;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class GuiReceiver
extends BaseGui {
    private static final Vector2Int MIDI_CHANNEL_WIDGET_COORDS = new Vector2Int(6, 31);
    private static final Vector2Int NOTE_FILTER_WIDGET_COORDS = new Vector2Int(180, 26);
    private static final Vector2Int TRANSMIT_SOURCE_WIDGET_COORDS = new Vector2Int(180, 59);
    private static final Vector2Int TRIGGER_MODE_WIDGET_COORDS = new Vector2Int(6, 104);
    private static final Vector2Int HOLD_TICKS_WIDGET_COORDS = new Vector2Int(180, 104);
    private static final Vector2Int INVERT_POWER_WIDGET_COORDS = new Vector2Int(281, 5);
    private static final Vector2Int ANALOG_MODE_WIDGET_COORDS = new Vector2Int(4, 5);
    private MidiChannelToggleWidget midiChannelToggle;
    private NoteFilterWidget noteFilter;
    private TransmitterSourceWidget transmitSource;
    private InvertSignalWidget invertSignal;
    private AnalogModeWidget analogMode;
    private TriggerModeWidget triggerMode;
    private HoldTicksWidget holdTicks;
    private final Player player;
    private final ItemStack receiverStack;
    private final BlockPos tilePos;
    private final InteractionHand handIn;

    public GuiReceiver(Player player, BlockPos tilePos, InteractionHand handIn, ItemStack receiverStack) {
        super(302, 131, 302, "textures/gui/container_receiver.png", "item.MIMIMod.gui_receiver");
        this.player = player;
        this.tilePos = tilePos;
        this.handIn = handIn;
        if (receiverStack == null || receiverStack.m_41619_()) {
            MIMIMod.LOGGER.error("Receiver stack is null or empty. Force closing GUI!");
            Minecraft.m_91087_().m_91346_((Screen)null);
            this.receiverStack = null;
            return;
        }
        this.receiverStack = new ItemStack((ItemLike)receiverStack.m_41720_(), receiverStack.m_41613_());
        this.receiverStack.m_41751_(receiverStack.m_41784_().m_6426_());
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.midiChannelToggle = new MidiChannelToggleWidget(this.receiverStack, new Vector2Int(this.START_X, this.START_Y), MIDI_CHANNEL_WIDGET_COORDS);
        this.noteFilter = new NoteFilterWidget(this.receiverStack, new Vector2Int(this.START_X, this.START_Y), NOTE_FILTER_WIDGET_COORDS);
        this.transmitSource = new TransmitterSourceWidget(this.receiverStack, this.player.m_20148_(), this.player.m_7755_().getString(), new Vector2Int(this.START_X, this.START_Y), TRANSMIT_SOURCE_WIDGET_COORDS);
        this.invertSignal = new InvertSignalWidget(this.receiverStack, new Vector2Int(this.START_X, this.START_Y), INVERT_POWER_WIDGET_COORDS);
        this.analogMode = new AnalogModeWidget(this.receiverStack, new Vector2Int(this.START_X, this.START_Y), ANALOG_MODE_WIDGET_COORDS);
        this.triggerMode = new TriggerModeWidget(this.receiverStack, new Vector2Int(this.START_X, this.START_Y), TRIGGER_MODE_WIDGET_COORDS);
        this.holdTicks = new HoldTicksWidget(this.receiverStack, new Vector2Int(this.START_X, this.START_Y), HOLD_TICKS_WIDGET_COORDS);
    }

    public void syncListenerToServer() {
        NetworkProxy.sendToServer(new ConfigurableMidiTileSyncPacket(this.receiverStack, this.tilePos, this.handIn));
    }

    public boolean m_6375_(double dmouseX, double dmouseY, int mouseButton) {
        int imouseX = (int)Math.round(dmouseX);
        int imouseY = (int)Math.round(dmouseY);
        if (this.midiChannelToggle.mouseClicked(imouseX, imouseY, mouseButton).booleanValue()) {
            this.syncListenerToServer();
        } else if (this.transmitSource.mouseClicked(imouseX, imouseY, mouseButton).booleanValue()) {
            this.syncListenerToServer();
        } else if (this.noteFilter.mouseClicked(imouseX, imouseY, mouseButton).booleanValue()) {
            this.syncListenerToServer();
        } else if (this.invertSignal.mouseClicked(imouseX, imouseY, mouseButton).booleanValue()) {
            this.syncListenerToServer();
        } else if (this.analogMode.mouseClicked(imouseX, imouseY, mouseButton).booleanValue()) {
            this.syncListenerToServer();
        } else if (this.triggerMode.mouseClicked(imouseX, imouseY, mouseButton).booleanValue()) {
            this.syncListenerToServer();
        } else if (this.holdTicks.mouseClicked(imouseX, imouseY, mouseButton).booleanValue()) {
            this.syncListenerToServer();
        }
        return super.m_6375_(dmouseX, dmouseY, mouseButton);
    }

    @Override
    protected PoseStack renderGraphics(PoseStack graphics, int mouseX, int mouseY, float partialTicks) {
        this.blitAbsolute(graphics, this.guiTexture, this.START_X, this.START_Y, 0.0f, 0.0f, this.GUI_WIDTH, this.GUI_HEIGHT, this.TEXTURE_SIZE, this.TEXTURE_SIZE);
        this.midiChannelToggle.renderGraphics(graphics, mouseX, mouseY);
        this.noteFilter.renderGraphics(graphics, mouseX, mouseY);
        this.transmitSource.renderGraphics(graphics, mouseX, mouseY);
        this.invertSignal.renderGraphics(graphics, mouseX, mouseY);
        this.analogMode.renderGraphics(graphics, mouseX, mouseY);
        this.triggerMode.renderGraphics(graphics, mouseX, mouseY);
        this.holdTicks.renderGraphics(graphics, mouseX, mouseY);
        return graphics;
    }

    @Override
    protected PoseStack renderText(PoseStack graphics, int mouseX, int mouseY, float partialTicks) {
        this.midiChannelToggle.renderText(graphics, this.f_96547_, mouseX, mouseY);
        this.noteFilter.renderText(graphics, this.f_96547_, mouseX, mouseY);
        this.transmitSource.renderText(graphics, this.f_96547_, mouseX, mouseY);
        this.invertSignal.renderText(graphics, this.f_96547_, mouseX, mouseY);
        this.analogMode.renderText(graphics, this.f_96547_, mouseX, mouseY);
        this.triggerMode.renderText(graphics, this.f_96547_, mouseX, mouseY);
        this.holdTicks.renderText(graphics, this.f_96547_, mouseX, mouseY);
        return graphics;
    }
}

