/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.tofodroid.mods.mimi.client.ClientProxy;
import io.github.tofodroid.mods.mimi.client.gui.BaseGui;
import io.github.tofodroid.mods.mimi.client.gui.CommonGuiUtils;
import io.github.tofodroid.mods.mimi.client.midi.AudioOutputDeviceManager;
import io.github.tofodroid.mods.mimi.client.midi.MidiInputDeviceManager;
import io.github.tofodroid.mods.mimi.client.midi.synth.MidiMultiSynthManager;
import io.github.tofodroid.mods.mimi.common.MIMIMod;
import io.github.tofodroid.mods.mimi.common.config.ConfigProxy;
import io.github.tofodroid.mods.mimi.util.Vector2Int;
import java.util.List;
import javax.sound.midi.MidiDevice;
import javax.sound.sampled.Mixer;
import net.minecraft.world.entity.player.Player;

public class GuiDeviceConfig
extends BaseGui {
    private static final Vector2Int AUDIO_DEVICE_BUTTON = new Vector2Int(7, 25);
    private static final Vector2Int VOLUME_DOWN_BUTTON = new Vector2Int(152, 26);
    private static final Vector2Int VOLUME_UP_BUTTON = new Vector2Int(186, 26);
    private static final Vector2Int MIDI_DEVICE_BUTTON = new Vector2Int(211, 25);
    private static final Vector2Int VELO_DOWN_BUTTON = new Vector2Int(137, 26);
    private static final Vector2Int VELO_UP_BUTTON = new Vector2Int(186, 26);
    private static final Vector2Int REFRESH_DEVICES_BUTTON = new Vector2Int(266, 114);
    private static final Vector2Int SHIFT_DEVICE_DOWN_BUTTON = new Vector2Int(8, 114);
    private static final Vector2Int SHIFT_DEVICE_UP_BUTTON = new Vector2Int(247, 114);
    private static final Vector2Int SAVE_DEVICE_BUTTON = new Vector2Int(266, 164);
    private static final Vector2Int VOLUME_BOX = new Vector2Int(171, 30);
    private static final Vector2Int VELO_BOX = new Vector2Int(156, 30);
    private static final Vector2Int MIDI_DEVICE_NAME_BOX = new Vector2Int(51, 51);
    private static final Vector2Int MIDI_DEVICE_STATUS_BOX = new Vector2Int(51, 66);
    private static final Vector2Int AUDIO_DEVICE_NAME_BOX = new Vector2Int(51, 46);
    private static final Vector2Int AUDIO_DEVICE_STATUS_BOX = new Vector2Int(51, 69);
    private Boolean audioMode = true;
    private Integer visibleDeviceId = -1;
    private MidiInputDeviceManager midiDeviceManager;
    private List<MidiDevice> availableMidiDevices;
    private MidiMultiSynthManager synthManager;
    private List<Mixer> availableAudioDevices;
    private List<String> availableAudioDeviceDisplayNames;

    public GuiDeviceConfig(Player player) {
        super(288, 187, 288, "textures/gui/gui_midi_config.png", "item.MIMIMod.gui_midi_input_config");
        this.midiDeviceManager = ((ClientProxy)MIMIMod.getProxy()).getMidiData().inputDeviceManager;
        this.availableMidiDevices = this.midiDeviceManager.getAvailableDevices();
        this.synthManager = ((ClientProxy)MIMIMod.getProxy()).getMidiSynth();
        this.availableAudioDevices = this.synthManager.audioDeviceManager.getAvailableOutputDevices();
        this.availableAudioDeviceDisplayNames = AudioOutputDeviceManager.getDeviceDisplayNames(this.availableAudioDevices);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int imouseX = (int)Math.round(mouseX);
        int imouseY = (int)Math.round(mouseY);
        if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(AUDIO_DEVICE_BUTTON), new Vector2Int(87, 14)).booleanValue()) {
            this.audioMode = true;
            this.visibleDeviceId = 0;
        } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(MIDI_DEVICE_BUTTON), new Vector2Int(70, 14)).booleanValue()) {
            this.audioMode = false;
            this.visibleDeviceId = 0;
        } else if (this.audioMode.booleanValue()) {
            if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(REFRESH_DEVICES_BUTTON)).booleanValue()) {
                this.visibleDeviceId = -1;
                this.availableAudioDevices = this.synthManager.audioDeviceManager.getAvailableOutputDevices();
                this.availableAudioDeviceDisplayNames = AudioOutputDeviceManager.getDeviceDisplayNames(this.availableAudioDevices);
            } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(SAVE_DEVICE_BUTTON)).booleanValue()) {
                if (this.visibleDeviceId == -1) {
                    this.synthManager.audioDeviceManager.setAutomaticDevice();
                    this.synthManager.reloadSynths();
                } else {
                    this.synthManager.audioDeviceManager.setDevice(this.availableAudioDeviceDisplayNames.get(this.visibleDeviceId));
                    this.synthManager.reloadSynths();
                }
            } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(SHIFT_DEVICE_UP_BUTTON)).booleanValue()) {
                this.visibleDeviceId = this.visibleDeviceId < this.availableAudioDevices.size() - 1 ? this.visibleDeviceId + 1 : this.visibleDeviceId;
            } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(SHIFT_DEVICE_DOWN_BUTTON)).booleanValue()) {
                this.visibleDeviceId = this.visibleDeviceId > -1 ? this.visibleDeviceId - 1 : this.visibleDeviceId;
            } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(VOLUME_UP_BUTTON)).booleanValue()) {
                Integer volume = ConfigProxy.getAudioDeviceVolume();
                ConfigProxy.setAudioDeviceVolume(volume < 10 ? volume + 1 : volume);
            } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(VOLUME_DOWN_BUTTON)).booleanValue()) {
                Integer volume = ConfigProxy.getAudioDeviceVolume();
                ConfigProxy.setAudioDeviceVolume(volume > 0 ? volume - 1 : volume);
            }
        } else if (!this.audioMode.booleanValue()) {
            if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(REFRESH_DEVICES_BUTTON)).booleanValue()) {
                this.visibleDeviceId = 0;
                this.availableMidiDevices = this.midiDeviceManager.getAvailableDevices();
            } else if (!this.midiDeviceManager.isDeviceSelected().booleanValue() && this.availableMidiDevices != null && this.availableMidiDevices.size() > this.visibleDeviceId && CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(SAVE_DEVICE_BUTTON)).booleanValue()) {
                this.midiDeviceManager.saveDeviceSelection(this.availableMidiDevices.get(this.visibleDeviceId));
            } else if (this.availableMidiDevices != null && CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(SHIFT_DEVICE_UP_BUTTON)).booleanValue()) {
                this.visibleDeviceId = this.visibleDeviceId < this.availableMidiDevices.size() - 1 ? this.visibleDeviceId + 1 : this.visibleDeviceId;
            } else if (this.availableMidiDevices != null && CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(SHIFT_DEVICE_DOWN_BUTTON)).booleanValue()) {
                this.visibleDeviceId = this.visibleDeviceId > 0 ? this.visibleDeviceId - 1 : this.visibleDeviceId;
            } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(VELO_UP_BUTTON)).booleanValue()) {
                Integer velocity = ConfigProxy.getMidiDeviceVelocity();
                ConfigProxy.setMidiDeviceVelocity(velocity < 127 ? velocity + 1 : velocity);
            } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(VELO_DOWN_BUTTON)).booleanValue()) {
                Integer velocity = ConfigProxy.getMidiDeviceVelocity();
                ConfigProxy.setMidiDeviceVelocity(velocity > -127 ? velocity - 1 : velocity);
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    @Override
    protected PoseStack renderGraphics(PoseStack graphics, int mouseX, int mouseY, float partialTicks) {
        this.blitAbsolute(graphics, this.guiTexture, this.START_X, this.START_Y, 0.0f, 0.0f, this.GUI_WIDTH, this.GUI_HEIGHT, this.TEXTURE_SIZE, this.TEXTURE_SIZE);
        if (this.audioMode.booleanValue()) {
            this.blitAbsolute(graphics, this.guiTexture, this.START_X + 4, this.START_Y + 22, 4.0f, 218.0f, 280, 69, this.TEXTURE_SIZE, this.TEXTURE_SIZE);
        }
        return graphics;
    }

    @Override
    protected PoseStack renderText(PoseStack graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.audioMode.booleanValue()) {
            List<String> statusLines;
            this.drawStringAbsolute(graphics, CommonGuiUtils.formatNumberAsString(ConfigProxy.getAudioDeviceVolume(), 2, false), this.START_X + VOLUME_BOX.x(), this.START_Y + VOLUME_BOX.y(), -16718336);
            List<String> nameLines = CommonGuiUtils.wrapString(this.f_96547_, this.synthManager.audioDeviceManager.getCurrentDeviceName(), 228, 2);
            if (!nameLines.isEmpty()) {
                this.drawStringAbsolute(graphics, this.f_96547_, nameLines.get(0), this.START_X + AUDIO_DEVICE_NAME_BOX.x(), this.START_Y + AUDIO_DEVICE_NAME_BOX.y(), -16718336);
                if (nameLines.size() > 1) {
                    this.drawStringAbsolute(graphics, this.f_96547_, CommonGuiUtils.truncateString(this.f_96547_, nameLines.get(1), 228), this.START_X + AUDIO_DEVICE_NAME_BOX.x(), this.START_Y + AUDIO_DEVICE_NAME_BOX.y() + 10, -16718336);
                }
            }
            if (!(statusLines = CommonGuiUtils.wrapString(this.f_96547_, this.synthManager.audioDeviceManager.getCurrentDeviceStatus(), 228, 2)).isEmpty()) {
                this.drawStringAbsolute(graphics, this.f_96547_, statusLines.get(0), this.START_X + AUDIO_DEVICE_STATUS_BOX.x(), this.START_Y + AUDIO_DEVICE_STATUS_BOX.y(), -16718336);
                if (statusLines.size() > 1) {
                    this.drawStringAbsolute(graphics, this.f_96547_, CommonGuiUtils.truncateString(this.f_96547_, statusLines.get(1), 228), this.START_X + AUDIO_DEVICE_STATUS_BOX.x(), this.START_Y + AUDIO_DEVICE_STATUS_BOX.y() + 10, -16718336);
                }
            }
            if (this.visibleDeviceId == -1) {
                this.drawStringAbsolute(graphics, this.f_96547_, "Automatic", this.START_X + 29, this.START_Y + 118, -16718336);
                this.drawStringAbsolute(graphics, this.f_96547_, "MIMI will attempt to connect to the same audio", this.START_X + 10, this.START_Y + 134, -16718336);
                this.drawStringAbsolute(graphics, this.f_96547_, "device that Minecraft is connected to. This", this.START_X + 10, this.START_Y + 144, -16718336);
                this.drawStringAbsolute(graphics, this.f_96547_, "usually works, but may not work if you are using", this.START_X + 10, this.START_Y + 154, -16718336);
                this.drawStringAbsolute(graphics, this.f_96547_, "a non-Windows operating system (Mac or Linux).", this.START_X + 10, this.START_Y + 164, -16718336);
            } else if (this.availableAudioDevices != null && this.availableAudioDevices.size() > this.visibleDeviceId) {
                this.drawStringAbsolute(graphics, this.f_96547_, CommonGuiUtils.truncateString(this.f_96547_, this.visibleDeviceId + ": " + this.availableAudioDeviceDisplayNames.get(this.visibleDeviceId), 212), this.START_X + 29, this.START_Y + 118, -16718336);
                Mixer.Info info = this.availableAudioDevices.get(this.visibleDeviceId).getMixerInfo();
                if (info != null) {
                    List<String> descLines = CommonGuiUtils.wrapString(this.f_96547_, "Description: " + info.getDescription(), 252, 2);
                    if (!descLines.isEmpty()) {
                        this.drawStringAbsolute(graphics, this.f_96547_, descLines.get(0), this.START_X + 10, this.START_Y + 134, -16718336);
                        if (descLines.size() > 1) {
                            this.drawStringAbsolute(graphics, this.f_96547_, CommonGuiUtils.truncateString(this.f_96547_, descLines.get(1), 228), this.START_X + 10, this.START_Y + 144, -16718336);
                        }
                    }
                    this.drawStringAbsolute(graphics, this.f_96547_, CommonGuiUtils.truncateString(this.f_96547_, "Vendor: " + info.getVendor(), 252), this.START_X + 10, this.START_Y + 158, -16718336);
                    this.drawStringAbsolute(graphics, this.f_96547_, CommonGuiUtils.truncateString(this.f_96547_, "Version: " + info.getVersion(), 252), this.START_X + 10, this.START_Y + 170, -16718336);
                } else if (this.availableAudioDevices == null || this.availableAudioDevices.isEmpty()) {
                    this.drawStringAbsolute(graphics, this.f_96547_, "No devices detected on system.", this.START_X + 10, this.START_Y + 134, -16718336);
                }
            }
        } else {
            Integer velo = ConfigProxy.getMidiDeviceVelocity();
            if (velo == 0) {
                this.drawStringAbsolute(graphics, "Input", this.START_X + VELO_BOX.x(), this.START_Y + VELO_BOX.y(), -16718336);
            } else {
                this.drawStringAbsolute(graphics, CommonGuiUtils.formatNumberAsString(ConfigProxy.getMidiDeviceVelocity(), 3, true), this.START_X + VELO_BOX.x(), this.START_Y + VELO_BOX.y(), -16718336);
            }
            if (this.midiDeviceManager.isDeviceSelected().booleanValue()) {
                this.drawStringAbsolute(graphics, this.f_96547_, CommonGuiUtils.truncateString(this.f_96547_, this.midiDeviceManager.getSelectedDeviceName(), 228), this.START_X + MIDI_DEVICE_NAME_BOX.x(), this.START_Y + MIDI_DEVICE_NAME_BOX.y(), -16718336);
                if (this.midiDeviceManager.isDeviceAvailable().booleanValue()) {
                    this.drawStringAbsolute(graphics, this.f_96547_, "Connected", this.START_X + MIDI_DEVICE_STATUS_BOX.x(), this.START_Y + MIDI_DEVICE_STATUS_BOX.y(), -16718336);
                } else if (this.midiDeviceManager.isDeviceError().booleanValue()) {
                    this.drawStringAbsolute(graphics, this.f_96547_, CommonGuiUtils.truncateString(this.f_96547_, "Error: " + this.midiDeviceManager.getSelectedDeviceError(), 252), this.START_X + MIDI_DEVICE_STATUS_BOX.x(), this.START_Y + MIDI_DEVICE_STATUS_BOX.y(), -16718336);
                } else {
                    this.drawStringAbsolute(graphics, this.f_96547_, "Error: Unavailable", this.START_X + MIDI_DEVICE_STATUS_BOX.x(), this.START_Y + MIDI_DEVICE_STATUS_BOX.y(), -16718336);
                }
            }
            if (this.availableMidiDevices != null && this.availableMidiDevices.size() > this.visibleDeviceId) {
                this.drawStringAbsolute(graphics, this.f_96547_, CommonGuiUtils.truncateString(this.f_96547_, this.visibleDeviceId + ": " + this.availableMidiDevices.get(this.visibleDeviceId).getDeviceInfo().getName(), 212), this.START_X + 29, this.START_Y + 118, -16718336);
                MidiDevice.Info info = this.availableMidiDevices.get(this.visibleDeviceId).getDeviceInfo();
                if (info != null) {
                    List<String> descLines = CommonGuiUtils.wrapString(this.f_96547_, "Description: " + info.getDescription(), 252, 2);
                    if (!descLines.isEmpty()) {
                        this.drawStringAbsolute(graphics, this.f_96547_, descLines.get(0), this.START_X + 10, this.START_Y + 134, -16718336);
                        if (descLines.size() > 1) {
                            this.drawStringAbsolute(graphics, this.f_96547_, CommonGuiUtils.truncateString(this.f_96547_, descLines.get(1), 228), this.START_X + 10, this.START_Y + 144, -16718336);
                        }
                    }
                    this.drawStringAbsolute(graphics, this.f_96547_, CommonGuiUtils.truncateString(this.f_96547_, "Vendor: " + info.getVendor(), 252), this.START_X + 10, this.START_Y + 158, -16718336);
                    this.drawStringAbsolute(graphics, this.f_96547_, CommonGuiUtils.truncateString(this.f_96547_, "Version: " + info.getVersion(), 252), this.START_X + 10, this.START_Y + 170, -16718336);
                }
            } else if (this.availableMidiDevices == null || this.availableMidiDevices.isEmpty()) {
                this.drawStringAbsolute(graphics, this.f_96547_, "No devices detected on system.", this.START_X + 10, this.START_Y + 134, -16718336);
            }
        }
        return graphics;
    }
}

