/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import io.github.tofodroid.mods.mimi.util.Vector2Int;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public abstract class CommonGuiUtils {
    public static final Integer STANDARD_BUTTON_SIZE = 15;

    public static final Boolean clickedBox(Integer mouseX, Integer mouseY, Vector2Int buttonPos) {
        return CommonGuiUtils.clickedBox(mouseX, mouseY, buttonPos, new Vector2Int(STANDARD_BUTTON_SIZE, STANDARD_BUTTON_SIZE));
    }

    public static final Boolean clickedBox(Integer mouseX, Integer mouseY, Vector2Int buttonPos, Vector2Int buttonSize) {
        Integer buttonMinX = buttonPos.x();
        Integer buttonMaxX = buttonMinX + buttonSize.x();
        Integer buttonMinY = buttonPos.y();
        Integer buttonMaxY = buttonMinY + buttonSize.y();
        Boolean result = mouseX >= buttonMinX && mouseX <= buttonMaxX && mouseY >= buttonMinY && mouseY <= buttonMaxY;
        if (result.booleanValue()) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
        }
        return result;
    }

    public static void setAlpha(float alpha) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
    }

    public static String formatNumberAsString(Integer value, Integer minDigits, Boolean includePlus) {
        String numberString = value.toString();
        if (value < 0) {
            numberString = numberString.substring(1);
        }
        return (value < 0 ? "-" : (includePlus != false ? "+" : "")) + (String)(numberString.length() < minDigits ? "0".repeat(minDigits - numberString.length()) + numberString : numberString);
    }

    public static String truncateString(Font font, String source, Integer maxWidth) {
        if (source == null || font.m_92895_(source) <= maxWidth) {
            return source;
        }
        return font.m_92834_("..." + source, maxWidth.intValue()).substring(3) + "...";
    }

    public static List<String> wrapString(Font font, String source, Integer maxWidth, Integer maxLines) {
        if (source == null || font.m_92895_(source) <= maxWidth) {
            return List.of(source);
        }
        ArrayList<String> lines = new ArrayList<String>();
        String remaining = source;
        do {
            String part = font.m_92834_(remaining, maxWidth.intValue());
            remaining = source.substring(part.length());
            lines.add(part);
        } while (font.m_92895_(remaining) > maxWidth || lines.size() <= maxLines);
        lines.add(remaining);
        return lines;
    }

    public static void blitAbsolute(PoseStack graphics, ResourceLocation texture, int renderStartX, int renderStartY, float atlasStartX, float atlasStartY, int sizeX, int sizeY, int textureSizeX, int textureSizeY) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        GuiComponent.m_93133_((PoseStack)graphics, (int)renderStartX, (int)renderStartY, (float)atlasStartX, (float)atlasStartY, (int)sizeX, (int)sizeY, (int)textureSizeX, (int)textureSizeY);
    }

    public static void drawStringAbsolute(PoseStack graphics, Font font, String string, Integer renderStartX, Integer renderStartY, Integer color) {
        GuiComponent.m_93236_((PoseStack)graphics, (Font)font, (String)string, (int)renderStartX, (int)renderStartY, (int)color);
    }

    public static void pushLayer(PoseStack graphics) {
        graphics.m_85836_();
    }

    public static void rotateLayer(PoseStack graphics, Float degrees) {
        graphics.m_85845_(new Quaternion(new Vector3f(0.0f, 0.0f, 1.0f), -90.0f, true));
    }

    public static void popLayer(PoseStack graphics) {
        graphics.m_85849_();
    }
}

