/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.com.sun.media.sound;

import io.github.tofodroid.com.sun.media.sound.ModelInstrument;
import io.github.tofodroid.com.sun.media.sound.ModelOscillator;
import io.github.tofodroid.com.sun.media.sound.ModelOscillatorStream;
import io.github.tofodroid.com.sun.media.sound.ModelPatch;
import io.github.tofodroid.com.sun.media.sound.ModelPerformer;
import io.github.tofodroid.com.sun.media.sound.SimpleInstrument;
import io.github.tofodroid.com.sun.media.sound.SimpleSoundbank;
import java.io.IOException;
import javax.sound.midi.Instrument;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.Patch;
import javax.sound.midi.Soundbank;
import javax.sound.midi.SoundbankResource;
import javax.sound.midi.VoiceStatus;

public abstract class ModelAbstractOscillator
implements ModelOscillator,
ModelOscillatorStream,
Soundbank {
    protected float pitch = 6000.0f;
    protected float samplerate;
    protected MidiChannel channel;
    protected VoiceStatus voice;
    protected int noteNumber;
    protected int velocity;
    protected boolean on = false;

    public void init() {
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void noteOff(int velocity) {
        this.on = false;
    }

    @Override
    public void noteOn(MidiChannel channel, VoiceStatus voice, int noteNumber, int velocity) {
        this.channel = channel;
        this.voice = voice;
        this.noteNumber = noteNumber;
        this.velocity = velocity;
        this.on = true;
    }

    @Override
    public int read(float[][] buffer, int offset, int len) throws IOException {
        return -1;
    }

    public MidiChannel getChannel() {
        return this.channel;
    }

    public VoiceStatus getVoice() {
        return this.voice;
    }

    public int getNoteNumber() {
        return this.noteNumber;
    }

    public int getVelocity() {
        return this.velocity;
    }

    public boolean isOn() {
        return this.on;
    }

    @Override
    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    public float getPitch() {
        return this.pitch;
    }

    public void setSampleRate(float samplerate) {
        this.samplerate = samplerate;
    }

    public float getSampleRate() {
        return this.samplerate;
    }

    @Override
    public float getAttenuation() {
        return 0.0f;
    }

    @Override
    public int getChannels() {
        return 1;
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    public Patch getPatch() {
        return new Patch(0, 0);
    }

    @Override
    public ModelOscillatorStream open(float samplerate) {
        ModelAbstractOscillator oscs;
        try {
            oscs = (ModelAbstractOscillator)this.getClass().newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException(e);
        }
        oscs.setSampleRate(samplerate);
        oscs.init();
        return oscs;
    }

    public ModelPerformer getPerformer() {
        ModelPerformer performer = new ModelPerformer();
        performer.getOscillators().add(this);
        return performer;
    }

    public ModelInstrument getInstrument() {
        SimpleInstrument ins = new SimpleInstrument();
        ins.setName(this.getName());
        ins.add(this.getPerformer());
        ins.setPatch(this.getPatch());
        return ins;
    }

    public Soundbank getSoundBank() {
        SimpleSoundbank sbk = new SimpleSoundbank();
        sbk.addInstrument(this.getInstrument());
        return sbk;
    }

    @Override
    public String getDescription() {
        return this.getName();
    }

    @Override
    public Instrument getInstrument(Patch patch) {
        ModelInstrument ins = this.getInstrument();
        Patch p = ins.getPatch();
        if (p.getBank() != patch.getBank()) {
            return null;
        }
        if (p.getProgram() != patch.getProgram()) {
            return null;
        }
        if (p instanceof ModelPatch && patch instanceof ModelPatch && ((ModelPatch)p).isPercussion() != ((ModelPatch)patch).isPercussion()) {
            return null;
        }
        return ins;
    }

    @Override
    public Instrument[] getInstruments() {
        return new Instrument[]{this.getInstrument()};
    }

    @Override
    public SoundbankResource[] getResources() {
        return new SoundbankResource[0];
    }

    @Override
    public String getVendor() {
        return null;
    }

    @Override
    public String getVersion() {
        return null;
    }
}

