/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.com.sun.media.sound;

import io.github.tofodroid.com.sun.media.sound.AuFileFormat;
import io.github.tofodroid.com.sun.media.sound.SunFileWriter;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.SequenceInputStream;
import java.util.Objects;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

public final class AuFileWriter
extends SunFileWriter {
    private static final int UNKNOWN_SIZE = -1;

    public AuFileWriter() {
        super(new AudioFileFormat.Type[]{AudioFileFormat.Type.AU});
    }

    @Override
    public AudioFileFormat.Type[] getAudioFileTypes(AudioInputStream stream) {
        AudioFileFormat.Type[] filetypes = new AudioFileFormat.Type[this.types.length];
        System.arraycopy(this.types, 0, filetypes, 0, this.types.length);
        AudioFormat format = stream.getFormat();
        AudioFormat.Encoding encoding = format.getEncoding();
        if (AudioFormat.Encoding.ALAW.equals(encoding) || AudioFormat.Encoding.ULAW.equals(encoding) || AudioFormat.Encoding.PCM_SIGNED.equals(encoding) || AudioFormat.Encoding.PCM_UNSIGNED.equals(encoding) || AudioFormat.Encoding.PCM_FLOAT.equals(encoding)) {
            return filetypes;
        }
        return new AudioFileFormat.Type[0];
    }

    @Override
    public int write(AudioInputStream stream, AudioFileFormat.Type fileType, OutputStream out) throws IOException {
        Objects.requireNonNull(stream);
        Objects.requireNonNull(fileType);
        Objects.requireNonNull(out);
        AuFileFormat auFileFormat = (AuFileFormat)this.getAudioFileFormat(fileType, stream);
        return this.writeAuFile(stream, auFileFormat, out);
    }

    @Override
    public int write(AudioInputStream stream, AudioFileFormat.Type fileType, File out) throws IOException {
        int bytesWritten;
        Objects.requireNonNull(stream);
        Objects.requireNonNull(fileType);
        Objects.requireNonNull(out);
        AuFileFormat auFileFormat = (AuFileFormat)this.getAudioFileFormat(fileType, stream);
        try (FileOutputStream fos = new FileOutputStream(out);
             BufferedOutputStream bos = new BufferedOutputStream(fos);){
            bytesWritten = this.writeAuFile(stream, auFileFormat, bos);
        }
        if (auFileFormat.getByteLength() == -1) {
            try (RandomAccessFile raf = new RandomAccessFile(out, "rw");){
                if (raf.length() <= Integer.MAX_VALUE) {
                    raf.skipBytes(8);
                    raf.writeInt(bytesWritten - 24);
                }
            }
        }
        return bytesWritten;
    }

    private AudioFileFormat getAudioFileFormat(AudioFileFormat.Type type, AudioInputStream stream) {
        if (!this.isFileTypeSupported(type, stream)) {
            throw new IllegalArgumentException("File type " + String.valueOf(type) + " not supported.");
        }
        AudioFormat streamFormat = stream.getFormat();
        AudioFormat.Encoding encoding = streamFormat.getEncoding();
        if (AudioFormat.Encoding.PCM_UNSIGNED.equals(encoding)) {
            encoding = AudioFormat.Encoding.PCM_SIGNED;
        }
        AudioFormat format = new AudioFormat(encoding, streamFormat.getSampleRate(), streamFormat.getSampleSizeInBits(), streamFormat.getChannels(), streamFormat.getFrameSize(), streamFormat.getFrameRate(), true);
        int fileSize = stream.getFrameLength() != -1L ? (int)stream.getFrameLength() * streamFormat.getFrameSize() + 24 : -1;
        return new AuFileFormat(AudioFileFormat.Type.AU, (long)fileSize, format, (long)((int)stream.getFrameLength()));
    }

    private InputStream getFileStream(AuFileFormat auFileFormat, AudioInputStream audioStream) throws IOException {
        byte[] header;
        long dataSizeInBytes;
        AudioFormat format = auFileFormat.getFormat();
        int headerSize = 24;
        long dataSize = auFileFormat.getFrameLength();
        long l = dataSizeInBytes = dataSize == -1L ? -1L : dataSize * (long)format.getFrameSize();
        if (dataSizeInBytes > Integer.MAX_VALUE) {
            dataSizeInBytes = -1L;
        }
        int auType = auFileFormat.getAuType();
        int sampleRate = (int)format.getSampleRate();
        int channels = format.getChannels();
        audioStream = AudioSystem.getAudioInputStream(format, audioStream);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             DataOutputStream dos = new DataOutputStream(baos);){
            dos.writeInt(779316836);
            dos.writeInt(headerSize);
            dos.writeInt((int)dataSizeInBytes);
            dos.writeInt(auType);
            dos.writeInt(sampleRate);
            dos.writeInt(channels);
            header = baos.toByteArray();
        }
        return new SequenceInputStream(new ByteArrayInputStream(header), new SunFileWriter.NoCloseInputStream(audioStream));
    }

    private int writeAuFile(AudioInputStream in, AuFileFormat auFileFormat, OutputStream out) throws IOException {
        int bytesRead = 0;
        int bytesWritten = 0;
        InputStream fileStream = this.getFileStream(auFileFormat, in);
        byte[] buffer = new byte[4096];
        int maxLength = auFileFormat.getByteLength();
        while ((bytesRead = fileStream.read(buffer)) >= 0) {
            if (maxLength > 0) {
                if (bytesRead < maxLength) {
                    out.write(buffer, 0, bytesRead);
                    bytesWritten += bytesRead;
                    maxLength -= bytesRead;
                    continue;
                }
                out.write(buffer, 0, maxLength);
                bytesWritten += maxLength;
                maxLength = 0;
                break;
            }
            out.write(buffer, 0, bytesRead);
            bytesWritten += bytesRead;
        }
        return bytesWritten;
    }
}

