/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.upgrades.engines.electric;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import xyz.przemyk.simpleplanes.client.ClientUtil;
import xyz.przemyk.simpleplanes.client.gui.PlaneInventoryScreen;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.misc.EnergyStorageWithSet;
import xyz.przemyk.simpleplanes.setup.SimplePlanesItems;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;
import xyz.przemyk.simpleplanes.upgrades.engines.EngineUpgrade;

public class ElectricEngineUpgrade
extends EngineUpgrade {
    public static final int CAPACITY = 1500000;
    public final EnergyStorageWithSet energyStorage = new EnergyStorageWithSet(1500000);
    public final LazyOptional<EnergyStorage> energyStorageLazyOptional = LazyOptional.of(() -> this.energyStorage);

    public ElectricEngineUpgrade(PlaneEntity planeEntity) {
        super((UpgradeType)SimplePlanesUpgrades.ELECTRIC_ENGINE.get(), planeEntity);
    }

    @Override
    public void tick() {
        if (this.planeEntity.getThrottle() > 0 && this.energyStorage.extractEnergy(12 * this.planeEntity.getFuelCost(), false) > 0) {
            this.updateClient();
        }
    }

    @Override
    public boolean isPowered() {
        return this.energyStorage.getEnergyStored() > 12 * this.planeEntity.getFuelCost();
    }

    @Override
    public void renderPowerHUD(PoseStack matrixStack, HumanoidArm side, int scaledWidth, int scaledHeight, float partialTicks) {
        int i = scaledWidth / 2;
        if (side == HumanoidArm.LEFT) {
            ClientUtil.blit(matrixStack, -90, i - 91 - 29, scaledHeight - 22, 38, 44, 22, 21);
        } else {
            ClientUtil.blit(matrixStack, -90, i + 91, scaledHeight - 22, 38, 44, 22, 21);
        }
        int energy = this.energyStorage.getEnergyStored();
        if (energy > 0) {
            int energyScaled = energy * 15 / 1500000;
            if (side == HumanoidArm.LEFT) {
                ClientUtil.blit(matrixStack, -90, i - 91 - 29 + 3, scaledHeight - 22 + 16 - energyScaled, 60, 57 - energyScaled, 16, energyScaled + 2);
            } else {
                ClientUtil.blit(matrixStack, -90, i + 91 + 3, scaledHeight - 22 + 16 - energyScaled, 60, 57 - energyScaled, 16, energyScaled + 2);
            }
        }
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.energyStorageLazyOptional.invalidate();
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compoundNBT = new CompoundTag();
        compoundNBT.m_128405_("energy", this.energyStorage.getEnergyStored());
        return compoundNBT;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        int energy = nbt.m_128451_("energy");
        this.energyStorage.setEnergy(Math.min(energy, 1500000));
    }

    @Override
    public void writePacket(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.energyStorage.getEnergyStored());
    }

    @Override
    public void readPacket(FriendlyByteBuf buffer) {
        this.energyStorage.setEnergy(buffer.m_130242_());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            this.updateClient();
            return this.energyStorageLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void onRemoved() {
        this.planeEntity.m_19998_((ItemLike)SimplePlanesItems.ELECTRIC_ENGINE.get());
    }

    @Override
    public void renderScreen(PoseStack poseStack, int mouseX, int mouseY, float partialTicks, PlaneInventoryScreen planeInventoryScreen) {
        if (planeInventoryScreen.m_6774_(152, 7, 16, 72, mouseX, mouseY)) {
            planeInventoryScreen.m_96602_(poseStack, (Component)Component.m_237110_((String)"simpleplanes.gui.energy", (Object[])new Object[]{this.energyStorage.getEnergyStored()}), mouseX, mouseY);
        }
    }

    @Override
    public void renderScreenBg(PoseStack poseStack, int x, int y, float partialTicks, PlaneInventoryScreen screen) {
        screen.m_93228_(poseStack, screen.getGuiLeft() + 152, screen.getGuiTop() + 7, 176, 0, 16, 72);
        int energy = this.energyStorage.getEnergyStored();
        if (energy > 0) {
            int energyScaled = energy * 71 / 1500000;
            screen.m_93228_(poseStack, screen.getGuiLeft() + 152, screen.getGuiTop() + 78 - energyScaled, 192, 71 - energyScaled, 16, energyScaled + 1);
        }
    }
}

