/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.network;

import com.mojang.math.Quaternion;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.misc.MathUtil;
import xyz.przemyk.simpleplanes.setup.SimplePlanesDataSerializers;

public class RotationPacket {
    private final Quaternion quaternion;

    public RotationPacket(Quaternion quaternion) {
        this.quaternion = quaternion;
    }

    public RotationPacket(FriendlyByteBuf buffer) {
        this.quaternion = (Quaternion)((EntityDataSerializer)SimplePlanesDataSerializers.QUATERNION_SERIALIZER_ENTRY.get()).m_6709_(buffer);
    }

    public void toBytes(FriendlyByteBuf buffer) {
        ((EntityDataSerializer)SimplePlanesDataSerializers.QUATERNION_SERIALIZER_ENTRY.get()).m_6856_(buffer, (Object)this.quaternion);
    }

    public void handle(Supplier<NetworkEvent.Context> ctxSup) {
        NetworkEvent.Context ctx = ctxSup.get();
        ctx.enqueueWork(() -> {
            Entity patt1160$temp;
            ServerPlayer sender = ctx.getSender();
            if (sender != null && (patt1160$temp = sender.m_20202_()) instanceof PlaneEntity) {
                PlaneEntity planeEntity = (PlaneEntity)patt1160$temp;
                planeEntity.setQ(this.quaternion);
                MathUtil.EulerAngles eulerAngles = MathUtil.toEulerAngles(this.quaternion);
                planeEntity.m_146922_((float)eulerAngles.yaw);
                planeEntity.m_146926_((float)eulerAngles.pitch);
                planeEntity.rotationRoll = (float)eulerAngles.roll;
                planeEntity.setQ_Client(this.quaternion);
            }
        });
        ctx.setPacketHandled(true);
    }
}

