/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.compat.jei;

import java.util.Arrays;
import java.util.stream.Stream;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import xyz.przemyk.simpleplanes.blocks.PlaneWorkbenchBlock;
import xyz.przemyk.simpleplanes.container.PlaneWorkbenchContainer;
import xyz.przemyk.simpleplanes.recipes.PlaneWorkbenchRecipe;
import xyz.przemyk.simpleplanes.setup.SimplePlanesBlocks;
import xyz.przemyk.simpleplanes.setup.SimplePlanesItems;

public class PlaneWorkbenchRecipeCategory
implements IRecipeCategory<PlaneWorkbenchRecipe> {
    public static final RecipeType<PlaneWorkbenchRecipe> RECIPE_TYPE = RecipeType.create((String)"simpleplanes", (String)"plane_workbench", PlaneWorkbenchRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public PlaneWorkbenchRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(new ResourceLocation("jei", "textures/gui/gui_vanilla.png"), 0, 168, 125, 18);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)SimplePlanesItems.PLANE_WORKBENCH.get()));
    }

    public RecipeType<PlaneWorkbenchRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return ((PlaneWorkbenchBlock)((Object)SimplePlanesBlocks.PLANE_WORKBENCH_BLOCK.get())).m_49954_();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, PlaneWorkbenchRecipe recipe, IFocusGroup focuses) {
        Stream<ItemStack> materialStackStream = ForgeRegistries.BLOCKS.tags().getTag(PlaneWorkbenchContainer.PLANE_MATERIALS_TAG).stream().map(block -> new ItemStack((ItemLike)block, recipe.materialAmount()));
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addIngredients(Ingredient.m_43921_(Arrays.stream(recipe.ingredient().m_43908_()).map(itemStack -> new ItemStack((ItemLike)itemStack.m_41720_(), recipe.ingredientAmount()))));
        builder.addSlot(RecipeIngredientRole.INPUT, 50, 1).addIngredients(Ingredient.m_43921_(materialStackStream));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 108, 1).addItemStack(recipe.result());
    }
}

