/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.jei;

import com.ldtteam.domumornamentum.IDomumOrnamentumApi;
import com.ldtteam.domumornamentum.block.IModBlocks;
import com.ldtteam.domumornamentum.jei.ArchitectsCutterCategory;
import com.ldtteam.domumornamentum.jei.MaterialSubtypeInterpreter;
import com.ldtteam.domumornamentum.recipe.ModRecipeTypes;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private IIngredientManager ingredientManager;

    @Nullable
    public IIngredientManager getIngredientManager() {
        return this.ingredientManager;
    }

    @NotNull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("domum_ornamentum");
    }

    public void registerItemSubtypes(@NotNull ISubtypeRegistration registration) {
        IModBlocks blocks = IDomumOrnamentumApi.getInstance().getBlocks();
        MaterialSubtypeInterpreter interpreter = MaterialSubtypeInterpreter.getInstance();
        registration.registerSubtypeInterpreter(blocks.getDoor().m_5456_(), (IIngredientSubtypeInterpreter)interpreter);
        registration.registerSubtypeInterpreter(blocks.getTrapdoor().m_5456_(), (IIngredientSubtypeInterpreter)interpreter);
        registration.registerSubtypeInterpreter(blocks.getFancyDoor().m_5456_(), (IIngredientSubtypeInterpreter)interpreter);
        registration.registerSubtypeInterpreter(blocks.getFancyTrapdoor().m_5456_(), (IIngredientSubtypeInterpreter)interpreter);
    }

    public void registerCategories(@NotNull IRecipeCategoryRegistration registration) {
        ArchitectsCutterCategory category = new ArchitectsCutterCategory(registration.getJeiHelpers().getGuiHelper(), this);
        registration.addRecipeCategories(new IRecipeCategory[]{category});
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        RecipeManager recipeManager = Minecraft.m_91087_().f_91073_.m_7465_();
        registration.addRecipes(ArchitectsCutterCategory.TYPE, recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.ARCHITECTS_CUTTER.get()));
    }

    public void registerRecipeCatalysts(@NotNull IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)IDomumOrnamentumApi.getInstance().getBlocks().getArchitectsCutter()), new RecipeType[]{ArchitectsCutterCategory.TYPE});
    }

    public void onRuntimeAvailable(@NotNull IJeiRuntime jeiRuntime) {
        this.ingredientManager = jeiRuntime.getIngredientManager();
    }
}

