/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.datagen.trapdoor.fancy;

import com.google.gson.JsonElement;
import com.ldtteam.datagenerators.IJsonSerializable;
import com.ldtteam.datagenerators.blockstate.BlockstateJson;
import com.ldtteam.datagenerators.blockstate.BlockstateModelJson;
import com.ldtteam.datagenerators.blockstate.BlockstateVariantJson;
import com.ldtteam.domumornamentum.block.ModBlocks;
import com.ldtteam.domumornamentum.block.decorative.FancyTrapdoorBlock;
import com.ldtteam.domumornamentum.block.types.FancyTrapdoorType;
import com.ldtteam.domumornamentum.util.DataGeneratorConstants;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.core.Direction;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import org.jetbrains.annotations.NotNull;

public class FancyTrapdoorsBlockStateProvider
implements DataProvider {
    private final DataGenerator generator;

    public FancyTrapdoorsBlockStateProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void m_213708_(@NotNull CachedOutput cache) throws IOException {
        this.createBlockstateFile(cache, ModBlocks.getInstance().getFancyTrapdoor());
    }

    private void createBlockstateFile(CachedOutput cache, FancyTrapdoorBlock shingle) throws IOException {
        if (shingle.getRegistryName() == null) {
            return;
        }
        HashMap<CallSite, BlockstateVariantJson> variants = new HashMap<CallSite, BlockstateVariantJson>();
        for (Direction facingValue : BlockStateProperties.f_61374_.m_6908_()) {
            for (FancyTrapdoorType typeValue : FancyTrapdoorBlock.TYPE.m_6908_()) {
                for (Half halfValue : TrapDoorBlock.f_57515_.m_6908_()) {
                    Iterator iterator = BlockStateProperties.f_61446_.m_6908_().iterator();
                    while (iterator.hasNext()) {
                        boolean openValue = (Boolean)iterator.next();
                        String variantKey = "facing=" + facingValue + ",type=" + typeValue.m_7912_() + ",half=" + halfValue + ",open=" + openValue;
                        int y = this.getYFromFacing(facingValue);
                        int x = this.getXFromOpenAndHalf(openValue, halfValue);
                        String modelLocation = "domum_ornamentum:block/trapdoors/fancy/trapdoor_" + typeValue.m_7912_();
                        BlockstateModelJson model = new BlockstateModelJson(modelLocation, x, y += this.getYFromOpenAndHalf(openValue, halfValue));
                        BlockstateVariantJson variant = new BlockstateVariantJson(model);
                        variants.put((CallSite)((Object)variantKey), variant);
                    }
                }
            }
        }
        BlockstateJson blockstate = new BlockstateJson(variants);
        Path blockstateFolder = this.generator.m_123916_().resolve("assets/domum_ornamentum/blockstates/");
        Path blockstatePath = blockstateFolder.resolve(shingle.getRegistryName().m_135815_() + ".json");
        DataProvider.m_236072_((CachedOutput)cache, (JsonElement)DataGeneratorConstants.serialize((IJsonSerializable)blockstate), (Path)blockstatePath);
    }

    private int getYFromFacing(Direction facing) {
        return switch (facing) {
            default -> 0;
            case Direction.SOUTH -> 180;
            case Direction.WEST -> 270;
            case Direction.EAST -> 90;
        };
    }

    private int getYFromOpenAndHalf(boolean open, Half half) {
        if (!open) {
            return half == Half.TOP ? 0 : 180;
        }
        return half == Half.TOP ? 180 : 0;
    }

    private int getXFromOpenAndHalf(boolean open, Half half) {
        if (!open) {
            return half == Half.TOP ? 180 : 0;
        }
        return half == Half.TOP ? -90 : 90;
    }

    @NotNull
    public String m_6055_() {
        return "FancyTrapdoors BlockStates Provider";
    }
}

