/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.datagen.fencegate;

import com.google.gson.JsonElement;
import com.ldtteam.datagenerators.IJsonSerializable;
import com.ldtteam.datagenerators.blockstate.BlockstateJson;
import com.ldtteam.datagenerators.blockstate.BlockstateModelJson;
import com.ldtteam.datagenerators.blockstate.BlockstateVariantJson;
import com.ldtteam.domumornamentum.block.ModBlocks;
import com.ldtteam.domumornamentum.block.vanilla.FenceGateBlock;
import com.ldtteam.domumornamentum.util.DataGeneratorConstants;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.core.Direction;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import org.jetbrains.annotations.NotNull;

public class FenceGateBlockStateProvider
implements DataProvider {
    private final DataGenerator generator;

    public FenceGateBlockStateProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void m_213708_(@NotNull CachedOutput cache) throws IOException {
        this.createBlockstateFile(cache, ModBlocks.getInstance().getFenceGate());
    }

    private void createBlockstateFile(CachedOutput cache, FenceGateBlock fenceGateBlock) throws IOException {
        if (fenceGateBlock.getRegistryName() == null) {
            return;
        }
        HashMap<CallSite, BlockstateVariantJson> variants = new HashMap<CallSite, BlockstateVariantJson>();
        for (Direction direction : HorizontalDirectionalBlock.f_54117_.m_6908_()) {
            Iterator iterator = FenceGateBlock.f_53343_.m_6908_().iterator();
            while (iterator.hasNext()) {
                boolean wallState = (Boolean)iterator.next();
                Iterator iterator2 = FenceGateBlock.f_53341_.m_6908_().iterator();
                while (iterator2.hasNext()) {
                    boolean open = (Boolean)iterator2.next();
                    String key = HorizontalDirectionalBlock.f_54117_.m_61708_() + "=" + direction.toString() + "," + FenceGateBlock.f_53343_.m_61708_() + "=" + wallState + "," + FenceGateBlock.f_53341_.m_61708_() + "=" + open;
                    int yRot = this.getYFromFacing(direction);
                    Object model = "domum_ornamentum:block/fence_gates/fence_gate_" + (wallState ? "wall_" : "") + (open ? "open_" : "");
                    model = ((String)model).substring(0, ((String)model).length() - 1);
                    variants.put((CallSite)((Object)key), new BlockstateVariantJson(new BlockstateModelJson((String)model, 0, yRot)));
                }
            }
        }
        BlockstateJson blockstate = new BlockstateJson(variants);
        Path blockstateFolder = this.generator.m_123916_().resolve("assets/domum_ornamentum/blockstates/");
        Path blockstatePath = blockstateFolder.resolve(fenceGateBlock.getRegistryName().m_135815_() + ".json");
        DataProvider.m_236072_((CachedOutput)cache, (JsonElement)DataGeneratorConstants.serialize((IJsonSerializable)blockstate), (Path)blockstatePath);
    }

    @NotNull
    public String m_6055_() {
        return "FenceGate BlockStates Provider";
    }

    private int getYFromFacing(Direction facing) {
        switch (facing) {
            default: {
                return 0;
            }
            case EAST: {
                return 90;
            }
            case SOUTH: {
                return 180;
            }
            case WEST: 
        }
        return 270;
    }
}

