/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.client.screens;

import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlock;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockComponent;
import com.ldtteam.domumornamentum.block.ModBlocks;
import com.ldtteam.domumornamentum.container.ArchitectsCutterContainer;
import com.ldtteam.domumornamentum.item.interfaces.IDoItem;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ArchitectsCutterScreen
extends AbstractContainerScreen<ArchitectsCutterContainer> {
    private static final ResourceLocation BACKGROUND_TEXTURE1 = new ResourceLocation("domum_ornamentum", "textures/gui/container/architectscutter.png");
    private static final ResourceLocation BACKGROUND_TEXTURE2 = new ResourceLocation("domum_ornamentum", "textures/gui/container/architectscutter2.png");
    private float recipeSliderProgress;
    private boolean clickedOnRecipeScroll;
    private int recipeIndexOffset;
    private float typeSliderProgress;
    private boolean clickedOnTypeScroll;
    private int typeIndexOffset;
    private static int groupIndexCache = 0;
    private static int variantIndexCache = -1;

    public ArchitectsCutterScreen(ArchitectsCutterContainer containerIn, Inventory playerInv, Component titleIn) {
        super((AbstractContainerMenu)containerIn, playerInv, titleIn);
        --this.f_97729_;
        this.f_97726_ = 242;
        this.f_97727_ = 202;
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.m_7025_(matrixStack, mouseX, mouseY);
    }

    protected void m_7286_(@NotNull PoseStack matrixStack, float partialTicks, int x, int y) {
        this.m_7333_(matrixStack);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getBackGroundTexture());
        int guiLeft = this.f_97735_;
        int guiTop = this.f_97736_;
        this.m_93228_(matrixStack, guiLeft, guiTop, 0, 0, this.f_97726_, this.f_97727_);
        if (((ArchitectsCutterContainer)this.f_97732_).getCurrentGroup() == null) {
            ((ArchitectsCutterContainer)this.f_97732_).m_6366_((Player)Objects.requireNonNull(Objects.requireNonNull(this.f_96541_).f_91074_), groupIndexCache);
            Objects.requireNonNull(this.f_96541_.f_91072_).m_105208_(((ArchitectsCutterContainer)this.f_97732_).f_38840_, groupIndexCache);
        }
        if (((ArchitectsCutterContainer)this.f_97732_).getCurrentGroup() != null && ((ArchitectsCutterContainer)this.f_97732_).getCurrentVariant() == null) {
            if (variantIndexCache == -1) {
                variantIndexCache = ModBlocks.getInstance().itemGroups.size();
            }
            ((ArchitectsCutterContainer)this.f_97732_).m_6366_((Player)Objects.requireNonNull(Objects.requireNonNull(this.f_96541_).f_91074_), variantIndexCache);
            Objects.requireNonNull(this.f_96541_.f_91072_).m_105208_(((ArchitectsCutterContainer)this.f_97732_).f_38840_, variantIndexCache);
        }
        if (((ArchitectsCutterContainer)this.f_97732_).getCurrentGroup() != null) {
            int sliderOffset1 = (int)(5.0f * this.recipeSliderProgress);
            this.m_93228_(matrixStack, guiLeft + 220, guiTop + 40 + sliderOffset1, 0 + (this.canScrollRecipes() ? 0 : 12), 222, 12, 15);
        }
        int sliderOffset2 = (int)(5.0f * this.typeSliderProgress);
        this.m_93228_(matrixStack, guiLeft + 220, guiTop + 17 + sliderOffset2, 0 + (this.canScrollTypes() ? 0 : 12), 222, 12, 15);
        int recipeAreaLeft = this.f_97735_ + 8 + 49;
        int recipeAreaTop = this.f_97736_ + 16;
        this.drawSlotBackgrounds(matrixStack);
        this.drawRecipeButtonBackgrounds(matrixStack, x, y, recipeAreaLeft, recipeAreaTop);
        this.drawRecipesItems(matrixStack, recipeAreaLeft, recipeAreaTop);
    }

    private ResourceLocation getBackGroundTexture() {
        return ((ArchitectsCutterContainer)this.f_97732_).getCurrentGroup() == null ? BACKGROUND_TEXTURE1 : BACKGROUND_TEXTURE2;
    }

    protected void m_7025_(@NotNull PoseStack matrixStack, int x, int y) {
        int k1;
        int j1;
        int i1;
        int l;
        super.m_7025_(matrixStack, x, y);
        int i = this.f_97735_ + 8 + 49;
        int j = this.f_97736_ + 16;
        int k = this.typeIndexOffset + 10;
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>(ModBlocks.getInstance().getOrComputeItemGroups().keySet());
        for (l = this.typeIndexOffset; l < k && l < list.size(); ++l) {
            i1 = l - this.typeIndexOffset;
            j1 = i + i1 % 10 * 16;
            k1 = j + i1 / 10 * 18 + 2;
            if (x < j1 || x >= j1 + 16 || y < k1 || y >= k1 + 18) continue;
            this.m_96602_(matrixStack, (Component)Component.m_237115_((String)("cuttergroup." + ((ResourceLocation)list.get(l)).m_135827_() + "." + ((ResourceLocation)list.get(l)).m_135815_())), x, y);
        }
        if (((ArchitectsCutterContainer)this.f_97732_).getCurrentGroup() != null) {
            List<ItemStack> list2 = ModBlocks.getInstance().getOrComputeItemGroups().get(((ArchitectsCutterContainer)this.f_97732_).getCurrentGroup());
            int i2 = this.f_97735_ + 8 + 49;
            int j2 = this.f_97736_ + 16 + 23;
            int k2 = this.recipeIndexOffset + 10;
            for (l = this.recipeIndexOffset; l < k2 && l < list2.size(); ++l) {
                ItemStack stack;
                i1 = l - this.recipeIndexOffset;
                j1 = i2 + i1 % 10 * 16;
                k1 = j2 + i1 / 10 * 18 + 2;
                if (x < j1 || x >= j1 + 16 || y < k1 || y >= k1 + 18) continue;
                if (((ArchitectsCutterContainer)this.f_97732_).outputInventorySlot.m_6657_()) {
                    ItemStack input = list2.get(l).m_41777_();
                    ItemStack output = ((ArchitectsCutterContainer)this.f_97732_).outputInventorySlot.m_7993_().m_41777_();
                    if (input.m_41782_() && output.m_41782_() && input.m_41783_().m_128441_("textureData") && output.m_41783_().m_128441_("textureData")) {
                        input.m_41783_().m_128365_("textureData", (Tag)ArchitectsCutterScreen.computeCompound(input, ((ArchitectsCutterContainer)this.f_97732_).outputInventorySlot.m_7993_()));
                    }
                    this.f_96541_.m_91291_().m_115203_(input, k2, i1);
                    stack = input;
                } else {
                    stack = list2.get(l);
                }
                this.m_6057_(matrixStack, stack, x, y);
            }
        }
    }

    protected void m_7027_(@NotNull PoseStack matrixStack, int p_282681_, int p_283686_) {
        this.f_96547_.m_92889_(matrixStack, (Component)Component.m_237115_((String)"domum_ornamentum.group"), 7.0f, 22.0f, 0x404040);
        this.f_96547_.m_92889_(matrixStack, (Component)Component.m_237115_((String)"domum_ornamentum.variant"), 7.0f, 45.0f, 0x404040);
        this.f_96547_.m_92889_(matrixStack, this.f_96539_, (float)(this.f_97728_ + 70), (float)this.f_97729_, 0x404040);
        this.f_96547_.m_92889_(matrixStack, this.f_169604_, (float)(this.f_97730_ + 32), (float)(this.f_97731_ + 36), 0x404040);
    }

    private void drawRecipeButtonBackgrounds(@NotNull PoseStack matrixStack, int x, int y, int recipeAreaLeft, int recipeAreaTop) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getBackGroundTexture());
        ArrayList<ResourceLocation> groups = new ArrayList<ResourceLocation>(ModBlocks.getInstance().getOrComputeItemGroups().keySet());
        for (int i = this.typeIndexOffset; i < this.typeIndexOffset + 10 && i < groups.size(); ++i) {
            int drawIndex = i - this.typeIndexOffset;
            int drawLeft = recipeAreaLeft + drawIndex % 10 * 16;
            int rowIndex = drawIndex / 10;
            int drawTop = recipeAreaTop + rowIndex * 18 + 2;
            int zOffset = 32;
            if (((ArchitectsCutterContainer)this.f_97732_).getCurrentGroup() != null && i == groups.indexOf(((ArchitectsCutterContainer)this.f_97732_).getCurrentGroup())) {
                zOffset = 0;
            } else if (x >= drawLeft && y >= drawTop && x < drawLeft + 16 && y < drawTop + 18) {
                zOffset = 16;
            }
            this.m_93228_(matrixStack, drawLeft, drawTop - 1, zOffset, this.f_97727_, 16, 18);
        }
        if (((ArchitectsCutterContainer)this.f_97732_).getCurrentGroup() != null) {
            List<ItemStack> list = ModBlocks.getInstance().getOrComputeItemGroups().get(((ArchitectsCutterContainer)this.f_97732_).getCurrentGroup());
            for (int i = this.recipeIndexOffset; i < this.recipeIndexOffset + 10 && i < list.size(); ++i) {
                int drawIndex = i - this.recipeIndexOffset;
                int drawLeft = recipeAreaLeft + drawIndex % 10 * 16;
                int rowIndex = drawIndex / 10;
                int drawTop = recipeAreaTop + 23 + rowIndex * 18 + 2;
                int zOffset = 32;
                if (((ArchitectsCutterContainer)this.f_97732_).getCurrentVariant() != null && i == list.indexOf(((ArchitectsCutterContainer)this.f_97732_).getCurrentVariant())) {
                    zOffset = 0;
                } else if (x >= drawLeft && y >= drawTop && x < drawLeft + 16 && y < drawTop + 18) {
                    zOffset = 16;
                }
                this.m_93228_(matrixStack, drawLeft, drawTop - 1, zOffset, this.f_97727_, 16, 18);
            }
        }
    }

    private void drawSlotBackgrounds(@NotNull PoseStack matrixStack) {
        BlockItem item;
        Item item2;
        if (((ArchitectsCutterContainer)this.f_97732_).getCurrentVariant() != null && (item2 = ((ArchitectsCutterContainer)this.f_97732_).getCurrentVariant().m_41720_()) instanceof BlockItem && (item2 = (item = (BlockItem)item2).m_40614_()) instanceof IMateriallyTexturedBlock) {
            IMateriallyTexturedBlock block = (IMateriallyTexturedBlock)item2;
            int sourceLeft = 48;
            int sourceTop = 202;
            int numComponents = block.getComponents().size();
            ArrayList<ResourceLocation> input = new ArrayList<ResourceLocation>();
            if (item instanceof IDoItem) {
                IDoItem doItem = (IDoItem)item;
                input.addAll(doItem.getInputIds());
            }
            for (int i = 0; i < 2; ++i) {
                int drawLeft = 95 + this.f_97735_;
                int drawTop = this.f_97736_ + 65 + i * 20;
                if (i < input.size()) {
                    this.f_96547_.m_92889_(matrixStack, (Component)Component.m_237110_((String)(((ResourceLocation)input.get(i)).m_135827_() + ".desc." + ((ResourceLocation)input.get(i)).m_135815_()), (Object[])new Object[]{Component.m_237110_((String)"domum_ornamentum.desc.material", (Object[])new Object[]{""})}), (float)drawLeft - 88.0f, (float)drawTop + 5.0f, 0x404040);
                }
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.m_157456_((int)0, (ResourceLocation)this.getBackGroundTexture());
                this.m_93228_(matrixStack, drawLeft, drawTop, 48 + (i >= numComponents ? 18 : 0), 202, 18, 18);
            }
        }
    }

    private void drawRecipesItems(@NotNull PoseStack poseStack, int left, int top) {
        ArrayList<ResourceLocation> typeList = new ArrayList<ResourceLocation>(ModBlocks.getInstance().getOrComputeItemGroups().keySet());
        for (int i = this.typeIndexOffset; i < this.typeIndexOffset + 10 && i < typeList.size(); ++i) {
            int j = i - this.typeIndexOffset;
            int k = left + j % 10 * 16;
            int l = j / 10;
            int i1 = top + l * 18 + 2;
            this.f_96541_.m_91291_().m_115203_(ModBlocks.getInstance().getOrComputeItemGroups().get(typeList.get(i)).get(0), k, i1);
        }
        if (((ArchitectsCutterContainer)this.f_97732_).getCurrentGroup() != null) {
            List<ItemStack> list = ModBlocks.getInstance().getOrComputeItemGroups().get(((ArchitectsCutterContainer)this.f_97732_).getCurrentGroup());
            for (int i = this.recipeIndexOffset; i < this.recipeIndexOffset + 10 && i < list.size(); ++i) {
                int j = i - this.recipeIndexOffset;
                int k = left + j % 10 * 16;
                int l = j / 10;
                int i1 = top + 23 + l * 18 + 2;
                if (((ArchitectsCutterContainer)this.f_97732_).outputInventorySlot.m_6657_()) {
                    ItemStack input = list.get(i).m_41777_();
                    ItemStack output = ((ArchitectsCutterContainer)this.f_97732_).outputInventorySlot.m_7993_().m_41777_();
                    if (input.m_41782_() && output.m_41782_() && input.m_41783_().m_128441_("textureData") && output.m_41783_().m_128441_("textureData")) {
                        input.m_41783_().m_128365_("textureData", (Tag)ArchitectsCutterScreen.computeCompound(input, ((ArchitectsCutterContainer)this.f_97732_).outputInventorySlot.m_7993_()));
                    }
                    this.f_96541_.m_91291_().m_115203_(input, k, i1);
                    continue;
                }
                this.f_96541_.m_91291_().m_115203_(list.get(i), k, i1);
            }
        }
    }

    private static CompoundTag computeCompound(ItemStack input, ItemStack output) {
        BlockItem inputBlockItem;
        Item item = input.m_41720_();
        if (item instanceof BlockItem && (item = (inputBlockItem = (BlockItem)item).m_40614_()) instanceof IMateriallyTexturedBlock) {
            BlockItem outputBlockItem;
            IMateriallyTexturedBlock inputTextureBlock = (IMateriallyTexturedBlock)item;
            item = output.m_41720_();
            if (item instanceof BlockItem && (item = (outputBlockItem = (BlockItem)item).m_40614_()) instanceof IMateriallyTexturedBlock) {
                IMateriallyTexturedBlock outputTextureBlock = (IMateriallyTexturedBlock)item;
                CompoundTag outputCompound = output.m_41783_().m_128469_("textureData");
                ArrayList<String> inputs = new ArrayList<String>();
                for (IMateriallyTexturedBlockComponent key : outputTextureBlock.getComponents()) {
                    inputs.add(outputCompound.m_128461_(key.getId().toString()));
                }
                int index = 0;
                CompoundTag inputCompound = input.m_41783_().m_128469_("textureData");
                for (IMateriallyTexturedBlockComponent key : inputTextureBlock.getComponents()) {
                    if (index >= inputs.size()) continue;
                    inputCompound.m_128359_(key.getId().toString(), (String)inputs.get(index));
                    ++index;
                }
                return inputCompound;
            }
        }
        return input.m_41783_().m_128469_("textureData");
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        double mouseYOffset;
        double mouseXOffset;
        int rowIndex;
        int index;
        int scrollOffset;
        int topOffset;
        int leftOffset;
        this.clickedOnRecipeScroll = false;
        this.clickedOnTypeScroll = false;
        if (((ArchitectsCutterContainer)this.f_97732_).getCurrentGroup() != null) {
            leftOffset = this.f_97735_ + 58;
            topOffset = this.f_97736_ + 16 + 23;
            scrollOffset = this.recipeIndexOffset + 10;
            for (index = this.recipeIndexOffset; index < scrollOffset; ++index) {
                rowIndex = index - this.recipeIndexOffset;
                mouseXOffset = mouseX - (double)(leftOffset + rowIndex % 10 * 16);
                mouseYOffset = mouseY - (double)(topOffset + rowIndex / 10 * 18);
                if (!(mouseXOffset >= 0.0) || !(mouseYOffset >= 0.0) || !(mouseXOffset < 16.0) || !(mouseYOffset < 18.0) || !((ArchitectsCutterContainer)this.f_97732_).m_6366_((Player)Objects.requireNonNull(Objects.requireNonNull(this.f_96541_).f_91074_), index + ModBlocks.getInstance().itemGroups.size())) continue;
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12495_, (float)1.0f));
                Objects.requireNonNull(this.f_96541_.f_91072_).m_105208_(((ArchitectsCutterContainer)this.f_97732_).f_38840_, index + ModBlocks.getInstance().itemGroups.size());
                variantIndexCache = index + ModBlocks.getInstance().itemGroups.size();
                return true;
            }
            leftOffset = this.f_97735_ + 220;
            if (mouseX >= (double)leftOffset && mouseX < (double)(leftOffset + 12) && mouseY >= (double)topOffset && mouseY < (double)(topOffset + 18)) {
                this.clickedOnRecipeScroll = true;
            }
        }
        if (!this.clickedOnRecipeScroll) {
            leftOffset = this.f_97735_ + 58;
            topOffset = this.f_97736_ + 16;
            scrollOffset = this.typeIndexOffset + 10;
            for (index = this.typeIndexOffset; index < scrollOffset; ++index) {
                rowIndex = index - this.typeIndexOffset;
                mouseXOffset = mouseX - (double)(leftOffset + rowIndex % 10 * 16);
                mouseYOffset = mouseY - (double)(topOffset + rowIndex / 10 * 18);
                if (!(mouseXOffset >= 0.0) || !(mouseYOffset >= 0.0) || !(mouseXOffset < 16.0) || !(mouseYOffset < 18.0) || !((ArchitectsCutterContainer)this.f_97732_).m_6366_((Player)Objects.requireNonNull(Objects.requireNonNull(this.f_96541_).f_91074_), index)) continue;
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12495_, (float)1.0f));
                Objects.requireNonNull(this.f_96541_.f_91072_).m_105208_(((ArchitectsCutterContainer)this.f_97732_).f_38840_, index);
                groupIndexCache = index;
                this.recipeIndexOffset = 0;
                this.recipeSliderProgress = 0.0f;
                return true;
            }
            leftOffset = this.f_97735_ + 220;
            if (mouseX >= (double)leftOffset && mouseX < (double)(leftOffset + 12) && mouseY >= (double)topOffset && mouseY < (double)(topOffset + 18)) {
                this.clickedOnTypeScroll = true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.clickedOnRecipeScroll && this.canScrollRecipes()) {
            int i = this.f_97736_ + 16 + 23;
            int j = i + 10;
            this.recipeSliderProgress = ((float)mouseY - (float)i - 7.5f) / ((float)(j - i) - 5.0f);
            this.recipeSliderProgress = Mth.m_14036_((float)this.recipeSliderProgress, (float)0.0f, (float)1.0f);
            this.recipeIndexOffset = (int)((double)(this.recipeSliderProgress * (float)this.getHiddenRecipeRows()) + 0.5) * 10;
            return true;
        }
        if (this.clickedOnTypeScroll && this.canScrollTypes()) {
            int i = this.f_97736_ + 16;
            int j = i + 10;
            this.typeSliderProgress = ((float)mouseY - (float)i - 7.5f) / ((float)(j - i) - 5.0f);
            this.typeSliderProgress = Mth.m_14036_((float)this.typeSliderProgress, (float)0.0f, (float)1.0f);
            this.typeIndexOffset = (int)((double)(this.typeSliderProgress * (float)this.getHiddenTypeRows()) + 0.5) * 10;
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        int i;
        boolean onlyTypes = false;
        if (mouseX >= (double)(this.f_97735_ + 55) && mouseY >= (double)(this.f_97736_ + 15) && mouseX < (double)(this.f_97735_ + 220) && mouseY < (double)(this.f_97736_ + 35)) {
            onlyTypes = true;
        }
        boolean onlyRecipes = false;
        if (mouseX >= (double)(this.f_97735_ + 55) && mouseY >= (double)(this.f_97736_ + 40) && mouseX < (double)(this.f_97735_ + 220) && mouseY < (double)(this.f_97736_ + 60)) {
            onlyRecipes = true;
        }
        if (this.canScrollRecipes() && !onlyTypes) {
            i = this.getHiddenRecipeRows();
            this.recipeSliderProgress = (float)((double)this.recipeSliderProgress - delta / (double)i);
            this.recipeSliderProgress = Mth.m_14036_((float)this.recipeSliderProgress, (float)0.0f, (float)1.0f);
            this.recipeIndexOffset = (int)((double)(this.recipeSliderProgress * (float)i) + 0.5) * 10;
        }
        if (this.canScrollTypes() && !onlyRecipes) {
            i = this.getHiddenTypeRows();
            this.typeSliderProgress = (float)((double)this.typeSliderProgress - delta / (double)i);
            this.typeSliderProgress = Mth.m_14036_((float)this.typeSliderProgress, (float)0.0f, (float)1.0f);
            this.typeIndexOffset = (int)((double)(this.typeSliderProgress * (float)i) + 0.5) * 10;
        }
        return true;
    }

    private boolean canScrollRecipes() {
        return ((ArchitectsCutterContainer)this.f_97732_).getCurrentGroup() != null && ModBlocks.getInstance().getOrComputeItemGroups().get(((ArchitectsCutterContainer)this.f_97732_).getCurrentGroup()).size() > 10;
    }

    private boolean canScrollTypes() {
        return ModBlocks.getInstance().getOrComputeItemGroups().size() > 10;
    }

    protected int getHiddenRecipeRows() {
        return ((ArchitectsCutterContainer)this.f_97732_).getCurrentGroup() == null ? 0 : (ModBlocks.getInstance().getOrComputeItemGroups().get(((ArchitectsCutterContainer)this.f_97732_).getCurrentGroup()).size() + 10 - 1) / 10 - 1;
    }

    protected int getHiddenTypeRows() {
        return (ModBlocks.getInstance().getOrComputeItemGroups().size() + 10 - 1) / 10 - 1;
    }
}

