/*
 * Decompiled with CFR 0.152.
 */
package team.creative.playerrevive.server;

import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import team.creative.creativecore.common.config.premade.MobEffectConfig;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.playerrevive.PlayerRevive;
import team.creative.playerrevive.api.DamageBledToDeath;
import team.creative.playerrevive.api.IBleeding;
import team.creative.playerrevive.cap.Bleeding;
import team.creative.playerrevive.packet.HelperPacket;
import team.creative.playerrevive.server.PlayerReviveServer;

public class ReviveEventServer {
    public static boolean isReviveActive(Entity player) {
        Player p;
        if (player instanceof Player && (p = (Player)player).m_7500_() && !PlayerRevive.CONFIG.bleeding.triggerForCreative) {
            return false;
        }
        return PlayerRevive.CONFIG.bleedInSingleplayer || player.m_20194_().m_6992_();
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.side == LogicalSide.SERVER && ReviveEventServer.isReviveActive((Entity)event.player)) {
            Player player = event.player;
            if (!player.m_6084_()) {
                return;
            }
            IBleeding revive = PlayerReviveServer.getBleeding(player);
            if (revive.isBleeding()) {
                revive.tick(player);
                if (revive.downedTime() % 5 == 0) {
                    PlayerReviveServer.sendUpdatePacket(player);
                }
                if (PlayerRevive.CONFIG.bleeding.affectHunger) {
                    player.m_36324_().m_38705_(PlayerRevive.CONFIG.bleeding.remainingHunger);
                }
                for (MobEffectConfig effect : PlayerRevive.CONFIG.bleeding.bleedingEffects) {
                    player.m_7292_(effect.create());
                }
                if (PlayerRevive.CONFIG.bleeding.shouldGlow) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 10));
                }
                if (revive.revived()) {
                    PlayerReviveServer.revive(player);
                } else if (revive.bledOut()) {
                    PlayerReviveServer.kill(player);
                }
            }
        }
    }

    @SubscribeEvent
    public void playerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        IBleeding revive = PlayerReviveServer.getBleeding(event.getEntity());
        if (revive.isBleeding()) {
            PlayerReviveServer.kill(event.getEntity());
        }
        if (!event.getEntity().f_19853_.f_46443_) {
            PlayerReviveServer.removePlayerAsHelper(event.getEntity());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void playerInteract(PlayerInteractEvent.EntityInteract event) {
        if (event.getTarget() instanceof Player && !event.getEntity().f_19853_.f_46443_) {
            Player target = (Player)event.getTarget();
            Player helper = event.getEntity();
            IBleeding revive = PlayerReviveServer.getBleeding(target);
            if (revive.isBleeding()) {
                event.setCanceled(true);
                if (PlayerRevive.CONFIG.revive.needReviveItem) {
                    if (PlayerRevive.CONFIG.revive.consumeReviveItem && !revive.isItemConsumed()) {
                        if (PlayerRevive.CONFIG.revive.reviveItem.is(helper.m_21205_())) {
                            helper.m_213846_((Component)Component.m_237115_((String)"playerrevive.revive.item").m_7220_(PlayerRevive.CONFIG.revive.reviveItem.description()));
                            return;
                        }
                        if (!helper.m_7500_()) {
                            helper.m_21205_().m_41774_(1);
                        }
                        revive.setItemConsumed();
                    } else if (!PlayerRevive.CONFIG.revive.reviveItem.is(helper.m_21205_())) {
                        return;
                    }
                }
                PlayerReviveServer.removePlayerAsHelper(helper);
                revive.revivingPlayers().add(helper);
                PlayerRevive.NETWORK.sendToClient((CreativePacket)new HelperPacket(target.m_20148_(), true), (ServerPlayer)helper);
            }
        }
    }

    @SubscribeEvent
    public void playerDamage(LivingHurtEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            IBleeding revive = PlayerReviveServer.getBleeding(player);
            if (revive.isBleeding()) {
                if (event.getSource() == DamageBledToDeath.BLED_TO_DEATH || PlayerRevive.CONFIG.bypassDamageSources.contains(event.getSource().f_19326_)) {
                    return;
                }
                if (revive.bledOut()) {
                    event.setCanceled(true);
                }
                if (revive.downedTime() <= PlayerRevive.CONFIG.bleeding.initialDamageCooldown) {
                    event.setCanceled(true);
                }
                if (event.getSource().m_7639_() instanceof Player) {
                    if (PlayerRevive.CONFIG.bleeding.disablePlayerDamage) {
                        event.setCanceled(true);
                    }
                } else if (event.getSource().m_7639_() instanceof LivingEntity) {
                    if (PlayerRevive.CONFIG.bleeding.disableMobDamage) {
                        event.setCanceled(true);
                    }
                } else if (PlayerRevive.CONFIG.bleeding.disableOtherDamage) {
                    event.setCanceled(true);
                }
            } else if (PlayerRevive.CONFIG.revive.abortOnDamage) {
                PlayerReviveServer.removePlayerAsHelper(player);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void playerDied(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (ReviveEventServer.isReviveActive((Entity)event.getEntity()) && !event.getEntity().f_19853_.f_46443_ && event.getSource() != DamageBledToDeath.BLED_TO_DEATH && !PlayerRevive.CONFIG.bypassDamageSources.contains(event.getSource().f_19326_)) {
                IBleeding revive = PlayerReviveServer.getBleeding(player);
                if (revive.bledOut() || revive.isBleeding()) {
                    if (revive.isBleeding()) {
                        PlayerRevive.CONFIG.sounds.death.play((Entity)player, SoundSource.PLAYERS);
                    }
                    for (Player helper : revive.revivingPlayers()) {
                        PlayerRevive.NETWORK.sendToClient((CreativePacket)new HelperPacket(null, false), (ServerPlayer)helper);
                    }
                    revive.revivingPlayers().clear();
                    return;
                }
                PlayerReviveServer.removePlayerAsHelper(player);
                PlayerRevive.NETWORK.sendToClient((CreativePacket)new HelperPacket(null, false), (ServerPlayer)player);
                PlayerReviveServer.startBleeding(player, event.getSource());
                if (player.m_20159_()) {
                    player.m_8127_();
                }
                event.setCanceled(true);
                if (PlayerRevive.CONFIG.bleeding.affectHunger) {
                    player.m_36324_().m_38705_(PlayerRevive.CONFIG.bleeding.remainingHunger);
                }
                player.m_21153_((float)PlayerRevive.CONFIG.bleeding.bleedingHealth);
                if (PlayerRevive.CONFIG.bleeding.bleedingMessage) {
                    if (PlayerRevive.CONFIG.bleeding.bleedingMessageTrackingOnly) {
                        player.m_20194_().m_6846_().m_240416_((Component)Component.m_237110_((String)"playerrevive.chat.bleeding", (Object[])new Object[]{player.m_5446_(), player.m_21231_().m_19293_()}), false);
                    } else {
                        player.m_20194_().m_6846_().m_240416_((Component)Component.m_237110_((String)"playerrevive.chat.bleeding", (Object[])new Object[]{player.m_5446_(), player.m_21231_().m_19293_()}), false);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(PlayerRevive.BLEEDING_NAME, new ICapabilityProvider(){
                private LazyOptional<IBleeding> bleed = LazyOptional.of(Bleeding::new);

                public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
                    return PlayerRevive.BLEEDING.orEmpty(cap, this.bleed);
                }
            });
        }
    }
}

