/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.gui.recipes;

import com.mojang.blaze3d.platform.InputConstants;
import mezz.jei.api.gui.inputs.IJeiInputHandler;
import mezz.jei.api.gui.inputs.IJeiUserInput;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.library.gui.recipes.RecipeLayout;
import net.minecraft.client.renderer.Rect2i;

public class RecipeLayoutInputHandler<T>
implements IJeiInputHandler {
    private final RecipeLayout<T> recipeLayout;

    public RecipeLayoutInputHandler(RecipeLayout<T> recipeLayout) {
        this.recipeLayout = recipeLayout;
    }

    @Override
    public Rect2i getArea() {
        return this.recipeLayout.getRect();
    }

    @Override
    public boolean handleInput(double mouseX, double mouseY, IJeiUserInput userInput) {
        if (!this.recipeLayout.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        Rect2i area = this.recipeLayout.getRect();
        double recipeMouseX = mouseX - (double)area.m_110085_();
        double recipeMouseY = mouseY - (double)area.m_110086_();
        if (userInput.isSimulate()) {
            return true;
        }
        IRecipeCategory<T> recipeCategory = this.recipeLayout.getRecipeCategory();
        T recipe = this.recipeLayout.getRecipe();
        return recipeCategory.handleInput(recipe, recipeMouseX, recipeMouseY, userInput.getKey());
    }

    @Override
    public boolean handleMouseDragged(double mouseX, double mouseY, InputConstants.Key mouseKey, double dragX, double dragY) {
        return false;
    }

    @Override
    public boolean handleMouseScrolled(double mouseX, double mouseY, double scrollDeltaY) {
        return false;
    }

    @Override
    public void handleMouseMoved(double mouseX, double mouseY) {
    }
}

